/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.dto.CIPermissionDto;
import com.xebialabs.deployit.engine.api.dto.EditRolePermissionsDto;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.spi.event.PermissionGrantedEvent;
import com.xebialabs.deployit.engine.spi.event.PermissionRevokedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class PermissionResource
extends AbstractSecuredResource
implements PermissionService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;
    @Autowired
    private RepositoryService repositoryService;
    private DtoWriter dtoWriter = new DtoWriter();
    @Context
    private HttpResponse response;
    private static final Logger logger = LoggerFactory.getLogger(PermissionResource.class);

    private static Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    private HashMap<String, Collection<String>> getStringCollectionHashMap(Map<String, List<String>> stringStringMultimap) {
        return new HashMap<String, Collection<String>>(stringStringMultimap.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public Map<String, Collection<String>> getGrantedPermissions(String roleName) {
        Role role = this.roleService.getRoleForRoleName(roleName);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(role));
    }

    public Map<String, Collection<String>> getGrantedPermissionsById(String roleId) {
        Role role = this.roleService.getRoleForRoleId(roleId);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(role));
    }

    public Map<String, Collection<String>> getMyGrantedPermissions() {
        Authentication authentication = Permissions.getAuthentication();
        List roles = this.roleService.getRolesFor(authentication);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(roles));
    }

    public boolean isGranted(String permissionName, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Permission permission = Permission.find((String)permissionName);
        Map rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        return rolePermissionMultimap.computeIfAbsent(role, r -> new HashSet()).contains(permission);
    }

    public void grant(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        this.permissionEditor.grant(role, PermissionResource.getPermission(permission), id);
        EventBusHolder.publish((Object)new PermissionGrantedEvent(id, roleName, permission));
    }

    public void revoke(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        this.permissionEditor.revoke(role, PermissionResource.getPermission(permission), id);
        EventBusHolder.publish((Object)new PermissionRevokedEvent(id, roleName, permission));
    }

    public boolean isGrantedToMe(String permission, String id) {
        return PermissionResource.getPermission(permission).getPermissionHandler().hasPermission(id);
    }

    public void updatePermissions(String onConfigurationItem, List<EditRolePermissionsDto> rolesWithPermissions) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        HashMap addedPermissions = new HashMap();
        HashMap removedPermissions = new HashMap();
        rolesWithPermissions.forEach(r -> {
            addedPermissions.put(this.roleService.getRoleForRoleName(r.getRoleName()), r.getAddedPermissions().stream().map(p -> PermissionResource.getPermission(p)).collect(Collectors.toList()));
            removedPermissions.put(this.roleService.getRoleForRoleName(r.getRoleName()), r.getRemovedPermissions().stream().map(p -> PermissionResource.getPermission(p)).collect(Collectors.toList()));
        });
        this.permissionEditor.updatePermissions(onConfigurationItem, addedPermissions, removedPermissions);
    }

    public void inheritParentPermissions(String id, CIPermissionDto request) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        boolean inheritParentPermissions = request.isInheritParentPermission();
        boolean isSecureCi = this.repositoryService.isSecure(id);
        List editRolePermissionsDtoList = request.getEditRolePermissionsDtoList();
        if (!inheritParentPermissions) {
            if (editRolePermissionsDtoList == null || editRolePermissionsDtoList.isEmpty()) {
                throw new EmptyPermissionException();
            }
            this.updatePermissions(id, editRolePermissionsDtoList);
        } else if (this.shouldUpdate(true, isSecureCi)) {
            this.permissionEditor.updatePermissions(id, new HashMap(), new HashMap());
        } else {
            logger.debug("Skipping update of permissions for CI {} as inheritParentPermissions={} and isSecureCi={}", new Object[]{id, inheritParentPermissions, isSecureCi});
        }
    }

    public CIPermissionDto getInheritParentPermissionsById(String id) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        boolean isSecureCi = this.repositoryService.isSecure(id);
        CIPermissionDto dto = new CIPermissionDto();
        dto.setInheritParentPermission(!isSecureCi);
        dto.setEditRolePermissionsDtoList(null);
        return dto;
    }

    public Map<String, Object> getIsInheritedParentAndPermissions(String id, String rolePattern, Paging paging, Ordering order, Boolean includeInherited) {
        Map rolePermissionMultimap;
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY});
        this.checkPermissions(new Permission[]{PlatformPermissions.VIEW_SECURITY});
        boolean isSecureCi = this.repositoryService.isSecure(id);
        String rootCI = id.split("/")[0];
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            rolePermissionMultimap = this.permissionEditor.readPermissions(id, includeInherited);
        } else {
            rolePermissionMultimap = this.permissionEditor.readPermissions(id, rolePattern, paging, order, includeInherited);
            PaginationSupport.addTotalCountHeader((long)this.roleService.countRoles(id, rolePattern), (HttpResponse)this.response);
        }
        return this.dtoWriter.writeAllPermissionsForRole(rolePermissionMultimap, isSecureCi, rootCI);
    }

    private boolean shouldUpdate(boolean inheritParentPermissions, boolean isSecureCi) {
        return inheritParentPermissions == isSecureCi;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class EmptyPermissionException
    extends DeployitException {
        public EmptyPermissionException() {
            super("RolePermissions must be defined if inheritParentPermissions is false");
        }
    }
}

