/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.core.rest.xml.Converters;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.stream.Collectors;

@XStreamProvider(tagName="descriptor", readable=Descriptor.class)
public class DescriptorWriter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Descriptor descriptor = (Descriptor)source;
        writer.addAttribute("type", descriptor.getType().toString());
        writer.addAttribute("label", descriptor.getLabel());
        if (descriptor.getDeployableType() != null) {
            writer.addAttribute("deployableType", descriptor.getDeployableType().toString());
        }
        if (descriptor.getContainerType() != null) {
            writer.addAttribute("containerType", descriptor.getContainerType().toString());
        }
        writer.addAttribute("virtual", Converters.bool(descriptor.isVirtual()));
        writer.addAttribute("versioned", Converters.bool(descriptor.isVersioned()));
        if (descriptor.getRootName() != null && !descriptor.getRootName().isEmpty()) {
            writer.addAttribute("root", descriptor.getRootName());
        }
        writer.startNode("description");
        writer.setValue(descriptor.getDescription());
        writer.endNode();
        if (descriptor.getIcon() != null) {
            writer.startNode("icon");
            writer.setValue(descriptor.getIcon());
            writer.endNode();
        }
        DescriptorWriter.writePropertyDescriptors(writer, descriptor);
        DescriptorWriter.writeControlTasks(writer, descriptor);
        DescriptorWriter.writeInterfaces(writer, descriptor);
        DescriptorWriter.writeSuperTypes(writer, descriptor);
    }

    private static void writeSuperTypes(HierarchicalStreamWriter writer, Descriptor descriptor) {
        writer.startNode("superTypes");
        for (Type type : descriptor.getSuperClasses()) {
            writer.startNode("superType");
            writer.setValue(type.toString());
            writer.endNode();
        }
        writer.endNode();
    }

    private static void writeInterfaces(HierarchicalStreamWriter writer, Descriptor descriptor) {
        writer.startNode("interfaces");
        for (Type type : descriptor.getInterfaces()) {
            writer.startNode("interface");
            writer.setValue(type.toString());
            writer.endNode();
        }
        writer.endNode();
    }

    private static void writeControlTasks(HierarchicalStreamWriter writer, Descriptor descriptor) {
        writer.startNode("control-tasks");
        for (MethodDescriptor methodDescriptor : descriptor.getControlTasks()) {
            writer.startNode("control-task");
            writer.addAttribute("name", methodDescriptor.getName());
            writer.addAttribute("fqn", methodDescriptor.getFqn());
            writer.addAttribute("description", methodDescriptor.getDescription());
            writer.addAttribute("label", methodDescriptor.getLabel());
            if (methodDescriptor.getParameterObjectType() != null) {
                writer.addAttribute("parameters-type", methodDescriptor.getParameterObjectType().toString());
            }
            if (!methodDescriptor.getAttributes().isEmpty()) {
                writer.startNode("attributes");
                for (Map.Entry entry : methodDescriptor.getAttributes().entrySet()) {
                    com.xebialabs.xltype.serialization.xstream.Converters.writeNode((String)((String)entry.getKey()), (String)((String)entry.getValue()), (HierarchicalStreamWriter)writer);
                }
                writer.endNode();
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private static void writePropertyDescriptors(HierarchicalStreamWriter writer, Descriptor descriptor) {
        writer.startNode("property-descriptors");
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            DescriptorWriter.wirtePropertyDescriptor(writer, pd);
        }
        writer.endNode();
    }

    private static void wirtePropertyDescriptor(HierarchicalStreamWriter writer, PropertyDescriptor pd) {
        writer.startNode("property-descriptor");
        writer.addAttribute("name", pd.getName());
        writer.addAttribute("fqn", pd.getFqn());
        writer.addAttribute("label", pd.getLabel());
        writer.addAttribute("kind", pd.getKind().name());
        writer.addAttribute("description", pd.getDescription());
        writer.addAttribute("category", pd.getCategory());
        writer.addAttribute("asContainment", Converters.bool(pd.isAsContainment()));
        writer.addAttribute("inspection", Converters.bool(pd.isInspectionProperty()));
        writer.addAttribute("required", Converters.bool(pd.isRequired()));
        writer.addAttribute("requiredInspection", Converters.bool(pd.isRequiredForInspection()));
        writer.addAttribute("password", Converters.bool(pd.isPassword()));
        writer.addAttribute("transient", Converters.bool(pd.isTransient()));
        writer.addAttribute("size", pd.getSize().name());
        if (pd.getCandidateValuesFilter() != null) {
            writer.addAttribute("candidateValuesFilter", pd.getCandidateValuesFilter());
        }
        if (pd.isHidden()) {
            writer.addAttribute("hidden", "true");
        }
        DescriptorWriter.writeDefaultAttributeForProperty(writer, pd);
        if (pd.getReferencedType() != null) {
            writer.startNode("referencedType");
            writer.setValue(pd.getReferencedType().toString());
            writer.endNode();
        }
        if (pd.getEnumValues() != null && !pd.getEnumValues().isEmpty()) {
            writer.startNode("enumValues");
            for (String s : pd.getEnumValues()) {
                writer.startNode("string");
                writer.setValue(s);
                writer.endNode();
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private static void writeDefaultAttributeForProperty(HierarchicalStreamWriter writer, PropertyDescriptor pd) {
        String defaultValue = null;
        switch (pd.getKind()) {
            case BOOLEAN: {
                if (pd.getDefaultValue() == null) break;
                defaultValue = Converters.bool((Boolean)pd.getDefaultValue());
                break;
            }
            case ENUM: {
                if (pd.getDefaultValue() == null) break;
                Object dV = pd.getDefaultValue();
                if (dV instanceof Enum) {
                    defaultValue = ((Enum)pd.getDefaultValue()).name();
                    break;
                }
                if (dV instanceof String) {
                    defaultValue = (String)dV;
                    break;
                }
                throw new IllegalStateException("Expected a String or Enum as default value for property " + pd.getFqn() + " of kind ENUM.");
            }
            case STRING: {
                if (pd.getDefaultValue() == null) break;
                defaultValue = (String)pd.getDefaultValue();
                break;
            }
            case INTEGER: {
                if (pd.getDefaultValue() == null) break;
                defaultValue = pd.getDefaultValue().toString();
                break;
            }
            case DATE: {
                if (pd.getDefaultValue() == null) break;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime((Date)pd.getDefaultValue());
                defaultValue = DatatypeConverter.printDateTime((Calendar)cal);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                defaultValue = DescriptorWriter.render((Collection)pd.getDefaultValue());
                break;
            }
            case MAP_STRING_STRING: {
                Map value = (Map)pd.getDefaultValue();
                defaultValue = DescriptorWriter.render(value);
                break;
            }
            case CI: 
            case SET_OF_CI: 
            case LIST_OF_CI: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported property kind: " + pd.getKind());
            }
        }
        if (defaultValue != null) {
            writer.addAttribute("default", defaultValue);
        }
    }

    private static String render(Collection<?> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        return items.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private static String render(Map<String, String> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        return items.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(", "));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        throw new IllegalStateException("Cannot unmarshal descriptors");
    }

    public boolean canConvert(Class type) {
        return Descriptor.class.isAssignableFrom(type);
    }
}

