package com.xebialabs.deployit.core.rest.resteasy;

import java.io.IOException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.security.Permissions;

@Provider
@Component
public class UsernameInjectorPrePostProcessor implements ContainerRequestFilter, ContainerResponseFilter {
    public static final String MDC_KEY_USERNAME = "username";

    @Override
    public void filter(final ContainerRequestContext requestContext, final ContainerResponseContext responseContext) throws IOException {
        cleanup();
    }

    public static void cleanup() {
        try {
            MDC.remove(MDC_KEY_USERNAME);
        } catch (Exception e) {
            logger.error("Error cleaning up after UsernameInjectorPrePostProcessor", e);
        }
    }

    @Override
    public void filter(final ContainerRequestContext requestContext) throws IOException {
        Authentication authentication = Permissions.getAuthentication();

        if (authentication != null) {
            MDC.put(MDC_KEY_USERNAME, authentication.getName());
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(UsernameInjectorPrePostProcessor.class);
}
