/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.security.Permissions;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UsernameInjectorPrePostProcessor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String MDC_KEY_USERNAME = "username";
    private static final Logger logger = LoggerFactory.getLogger(UsernameInjectorPrePostProcessor.class);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        UsernameInjectorPrePostProcessor.cleanup();
    }

    public static void cleanup() {
        try {
            MDC.remove((String)MDC_KEY_USERNAME);
        }
        catch (Exception e) {
            logger.error("Error cleaning up after UsernameInjectorPrePostProcessor", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Authentication authentication = Permissions.getAuthentication();
        if (authentication != null) {
            MDC.put((String)MDC_KEY_USERNAME, (String)authentication.getName());
        }
    }
}

