package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.io.TemporaryFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;

@Provider
@Component
public class TemporaryFilesPrePostProcessorInterceptor implements ContainerResponseFilter {

    @Override
    public void filter(final ContainerRequestContext requestContext, final ContainerResponseContext responseContext) throws IOException {
        cleanup();
    }

    public static void cleanup() {
        try {
            TemporaryFiles.clear();
        } catch (Exception e) {
            logger.error("Error cleaning up after TemporaryFilesPrePostProcessorInterceptor", e);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(TemporaryFilesPrePostProcessorInterceptor.class);
}
