/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\f\u0019\u0001\u0015B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019Q\u0006\u0001)A\u0005/\"91\f\u0001b\u0001\n\u0003a\u0006BB4\u0001A\u0003%Q\fC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005M\u0001\u0001\"\u0011\u0002T!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!a!\u0001\t\u0003\n\t\nC\u0004\u0002\u0004\u0002!I!!'\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002\\\u0002!I!!8\u0003\u0019I{G.\u001a*fg>,(oY3\u000b\u0005eQ\u0012aA1qS*\u00111\u0004H\u0001\u0005e\u0016\u001cHO\u0003\u0002\u001e=\u0005!1m\u001c:f\u0015\ty\u0002%\u0001\u0005eKBdw._5u\u0015\t\t#%A\u0005yK\nL\u0017\r\\1cg*\t1%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001M1\u001a\u0004CA\u0014+\u001b\u0005A#BA\u0015\u001b\u0003\u001d\u0019XmY;sK\u0012L!a\u000b\u0015\u0003/\u0005\u00137\u000f\u001e:bGR\u001cVmY;sK\u0012\u0014Vm]8ve\u000e,\u0007CA\u00172\u001b\u0005q#BA\r0\u0015\t\u0001d$\u0001\u0004f]\u001eLg.Z\u0005\u0003e9\u00121BU8mKN+'O^5dKB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006g24GG\u001b\u0006\u0002q\u0005AqM]5{u2,G-\u0003\u0002;k\t9Aj\\4hS:<\u0017aB:feZL7-\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fy\t\u0001b]3dkJLG/_\u0005\u0003ey\na\u0001P5oSRtDCA\"F!\t!\u0005!D\u0001\u0019\u0011\u0015Y$\u00011\u0001=Q\t\u0011q\t\u0005\u0002I'6\t\u0011J\u0003\u0002K\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051k\u0015a\u00024bGR|'/\u001f\u0006\u0003\u001d>\u000bQAY3b]NT!\u0001U)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AU\u0001\u0004_J<\u0017B\u0001+J\u0005%\tU\u000f^8xSJ,G-A\u0005ei><&/\u001b;feV\tq\u000b\u0005\u0002E1&\u0011\u0011\f\u0007\u0002\n\tR|wK]5uKJ\f!\u0002\u001a;p/JLG/\u001a:!\u0003!\u0011Xm\u001d9p]N,W#A/\u0011\u0005y+W\"A0\u000b\u0005\u0001\f\u0017aA:qS*\u0011!mY\u0001\te\u0016\u001cH/Z1ts*\u0011A-U\u0001\u0006U\n|7o]\u0005\u0003M~\u0013A\u0002\u0013;uaJ+7\u000f]8og\u0016\f\u0011B]3ta>t7/\u001a\u0011)\u0005\u0019I\u0007C\u00016s\u001b\u0005Y'BA\u000fm\u0015\tig.\u0001\u0002sg*\u0011q\u000e]\u0001\u0003oNT\u0011!]\u0001\u0006U\u00064\u0018\r_\u0005\u0003g.\u0014qaQ8oi\u0016DH/\u0001\u0004fq&\u001cHo\u001d\u000b\u0003mr\u0004\"a\u001e>\u000e\u0003aT\u0011!_\u0001\u0006g\u000e\fG.Y\u0005\u0003wb\u0014qAQ8pY\u0016\fg\u000eC\u0003~\u000f\u0001\u0007a0\u0001\u0005s_2,g*Y7f!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004al!!!\u0002\u000b\u0007\u0005\u001dA%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017A\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\fa\fA\u0001\\5tiRQ\u0011qCA\u0019\u0003k\tI$!\u0013\u0011\r\u0005e\u00111EA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001B;uS2T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0003MSN$\b\u0003BA\u0015\u0003[i!!a\u000b\u000b\u0005}r\u0013\u0002BA\u0018\u0003W\u0011AAU8mK\"1\u00111\u0007\u0005A\u0002y\f!!\u001b3\t\r\u0005]\u0002\u00021\u0001\u007f\u0003-\u0011x\u000e\\3QCR$XM\u001d8\t\u000f\u0005m\u0002\u00021\u0001\u0002>\u00051\u0001/Y4j]\u001e\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007r\u0013a\u00013u_&!\u0011qIA!\u0005\u0019\u0001\u0016mZ5oO\"9\u00111\n\u0005A\u0002\u00055\u0013!B8sI\u0016\u0014\b\u0003BA \u0003\u001fJA!!\u0015\u0002B\tAqJ\u001d3fe&tw\r\u0006\u0005\u0002V\u0005]\u0013\u0011LA.!\u0015\tI\"a\t\u007f\u0011\u0019\t9$\u0003a\u0001}\"9\u00111H\u0005A\u0002\u0005u\u0002bBA&\u0013\u0001\u0007\u0011QJ\u0001\fY&\u001cH/T=S_2,7\u000f\u0006\u0005\u0002V\u0005\u0005\u00141MA3\u0011\u0019\t9D\u0003a\u0001}\"9\u00111\b\u0006A\u0002\u0005u\u0002bBA&\u0015\u0001\u0007\u0011QJ\u0001\nY&\u001cHOU8mKN$\"\"!\u0016\u0002l\u0005=\u0014\u0011OA:\u0011\u0019\tig\u0003a\u0001}\u0006AQo]3s]\u0006lW\r\u0003\u0004\u00028-\u0001\rA \u0005\b\u0003wY\u0001\u0019AA\u001f\u0011\u001d\tYe\u0003a\u0001\u0003\u001b\naa\u0019:fCR,G\u0003BA=\u0003\u007f\u00022a^A>\u0013\r\ti\b\u001f\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u00022\u0001\rA`\u0001\u0005]\u0006lW-\u0001\tva\u0012\fG/\u001a)sS:\u001c\u0017\u000e]1mgR!\u0011\u0011PAD\u0011\u001d\tI)\u0004a\u0001\u0003\u0017\u000baB]8mKB\u0013\u0018N\\2ja\u0006d7\u000f\u0005\u0003\u0002*\u00055\u0015\u0002BAH\u0003W\u0011aBU8mKB\u0013\u0018N\\2ja\u0006d7\u000f\u0006\u0004\u0002z\u0005M\u0015Q\u0013\u0005\u0007\u0003\u0003s\u0001\u0019\u0001@\t\u000f\u0005]e\u00021\u0001\u0002V\u0005Q\u0001O]5oG&\u0004\u0018\r\\:\u0015\u0011\u0005e\u00141TAO\u0003?Ca!a\r\u0010\u0001\u0004q\bBBAA\u001f\u0001\u0007a\u0010C\u0004\u0002\u0018>\u0001\r!!\u0016\u0002\r\u0005\u001c8/[4o)\u0019\tI(!*\u0002(\"1\u0011\u0011\u0011\tA\u0002yDa!!+\u0011\u0001\u0004q\u0018!\u00039sS:\u001c\u0017\u000e]1m\u0003!)h.Y:tS\u001etGCBA=\u0003_\u000b\t\f\u0003\u0004\u0002\u0002F\u0001\rA \u0005\u0007\u0003S\u000b\u0002\u0019\u0001@\u0002\rI,g.Y7f)\u0019\tI(a.\u0002:\"1\u0011\u0011\u0011\nA\u0002yDa!a/\u0013\u0001\u0004q\u0018a\u00028fo:\u000bW.Z\u0001\u0007I\u0016dW\r^3\u0015\t\u0005e\u0014\u0011\u0019\u0005\u0007\u0003\u0003\u001b\u0002\u0019\u0001@\u0002%I,\u0017\r\u001a*pY\u0016\u0004&/\u001b8dSB\fGn\u001d\u000b\t\u0003\u000f\fI-a3\u0002NB1\u0011\u0011DA\u0012\u0003\u0017Ca!a\u000e\u0015\u0001\u0004q\bbBA\u001e)\u0001\u0007\u0011Q\b\u0005\b\u0003\u0017\"\u0002\u0019AA'\u0003y1\u0017N]3S_2,\u0007K]5oG&\u0004\u0018\r\\:DQ\u0006tw-\u001a3Fm\u0016tG\u000f\u0006\u0003\u0002z\u0005M\u0007bBAE+\u0001\u0007\u0011Q\u001b\t\u0007\u00033\t\u0019#a6\u0011\u0007u\nI.C\u0002\u00020y\nqb]1oSRL8\t[3dWJ{G.\u001a\u000b\u0005\u0003s\ny\u000e\u0003\u0004~-\u0001\u0007\u0011\u0011\u001d\t\u0005o\u0006\rh0C\u0002\u0002fb\u0014aa\u00149uS>t\u0007f\u0001\u0001\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002p>\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\u00190!<\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class RoleResource
extends AbstractSecuredResource
implements RoleService,
Logging {
    private final com.xebialabs.deployit.security.RoleService service;
    private final DtoWriter dtoWriter;
    @Context
    private final HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @GET
    public List<String> list() {
        return super.list();
    }

    @GET
    @Path(value="roles")
    public List<String> listMyRoles() {
        return super.listMyRoles();
    }

    @GET
    @Path(value="roles/{username}")
    public List<String> listRoles(String x$1) {
        return super.listRoles(x$1);
    }

    @GET
    @Path(value="principals")
    public List<RolePrincipals> readRolePrincipals() {
        return super.readRolePrincipals();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RoleResource roleResource = this;
        synchronized (roleResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private DtoWriter dtoWriter() {
        return this.dtoWriter;
    }

    public HttpResponse response() {
        return this.response;
    }

    public boolean exists(String roleName) {
        return this.service.roleExists(roleName);
    }

    public List<com.xebialabs.deployit.engine.api.security.Role> list(String id, String rolePattern, Paging paging, Ordering order) {
        List<com.xebialabs.deployit.engine.api.security.Role> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.dtoWriter().writeRoles(this.service.getRoles(id));
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles(id, rolePattern), this.response());
            list = this.dtoWriter().writeRoles(this.service.getRoles(id, rolePattern, paging, order));
        }
        return list;
    }

    public List<String> list(String rolePattern, Paging paging, Ordering order) {
        List<String> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.service.getRoles().stream().map(x$1 -> x$1.getName()).collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern), this.response());
            list = this.service.getRoles(rolePattern, paging, order).stream().map(x$2 -> x$2.getName()).collect(Collectors.toList());
        }
        return list;
    }

    public List<String> listMyRoles(String rolePattern, Paging paging, Ordering order) {
        return this.service.getRolesFor(Permissions.getAuthentication(), rolePattern, paging, order).stream().map(x$3 -> x$3.getName()).collect(Collectors.toList());
    }

    public List<String> listRoles(String username, String rolePattern, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        return this.service.getRolesFor(username, rolePattern, paging, order).stream().map(x$4 -> x$4.getName()).collect(Collectors.toList());
    }

    public void create(String name) {
        block0: {
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
            this.sanityCheckRole((Option<String>)Option$.MODULE$.apply((Object)name));
            if (this.service.roleExists(name)) break block0;
            this.service.create(name);
            EventBusHolder.publish((Object)new RoleCreatedEvent(name));
        }
    }

    public void updatePrincipals(RolePrincipals rolePrincipals) {
        this.updatePrincipals(rolePrincipals.getRole().getId(), rolePrincipals.getRole().getName(), rolePrincipals.getPrincipals());
    }

    public void updatePrincipals(String name, List<String> principals) {
        this.updatePrincipals(null, name, principals);
    }

    private void updatePrincipals(String id, String name, List<String> principals) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.sanityCheckRole((Option<String>)Option$.MODULE$.apply((Object)name));
        Role role = new Role(id, name, principals);
        this.service.createOrUpdateRole(role);
        this.fireRolePrincipalsChangedEvent(this.service.readRoleAssignments());
    }

    public void assign(String name, String principal) {
        Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().$colon$plus((Object)principal);
        this.updatePrincipals(name, CollectionConverters$.MODULE$.BufferHasAsJava(newPrincipals).asJava());
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentCreatedEvent(principal, name));
    }

    public void unassign(String name, String principal) {
        Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RoleResource.$anonfun$unassign$1(principal, p)));
        this.updatePrincipals(name, CollectionConverters$.MODULE$.BufferHasAsJava(newPrincipals).asJava());
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentDeletedEvent(principal, name));
    }

    public void rename(String name, String newName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.sanityCheckRole((Option<String>)Option$.MODULE$.apply((Object)newName));
        this.service.rename(name, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(name, newName));
    }

    public void delete(String name) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.service.deleteByName(name);
        EventBusHolder.publish((Object)new RoleDeletedEvent(name));
    }

    public List<RolePrincipals> readRolePrincipals(String rolePattern, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        ObjectRef multimap = ObjectRef.create(null);
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            multimap.elem = this.service.readRoleAssignments();
        } else {
            multimap.elem = this.service.readRoleAssignments(rolePattern, paging, order);
            long total = this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern);
            PaginationSupport$.MODULE$.addTotalCountHeader(total, this.response());
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(61).append("com.xebialabs.deployit.security.RoleService delivered roles: ").append((List)multimap$1.elem).toString());
        List<RolePrincipals> assignments = this.dtoWriter().writeRoleAssignments((List)multimap.elem);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Going to return the following roles: ").append(assignments).toString());
        return assignments;
    }

    private void fireRolePrincipalsChangedEvent(List<Role> rolePrincipals) {
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(rolePrincipals.stream().map(r -> new StringBuilder(4).append(r.getName()).append(" => ").append(r.getPrincipals()).toString()).collect(Collectors.toList())));
    }

    private void sanityCheckRole(Option<String> roleName) {
        roleName.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5.trim())))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Role name cannot be empty");
        });
    }

    public static final /* synthetic */ boolean $anonfun$unassign$1(String principal$1, String p) {
        String string = p;
        String string2 = principal$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public RoleResource(com.xebialabs.deployit.security.RoleService service) {
        this.service = service;
        Logging.$init$((Logging)this);
        this.dtoWriter = new DtoWriter();
        this.response = null;
    }
}

