package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.security.permission.Permission;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


@Component
public class DtoWriter {
    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream().map(DtoWriter::writeRole).collect(Collectors.toList());
    }

    private static Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RolePrincipals> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream()
                .map(r -> new RolePrincipals(writeRole(r), r.getPrincipals()))
                .collect(Collectors.toList());
    }

    public List<RolePermissions> writeRolePermissions(Map<com.xebialabs.deployit.security.Role, Set<Permission>> multimap) {
        return multimap.keySet()
                .stream()
                .map(role -> new RolePermissions(writeRole(role), writePermissions(multimap.get(role))))
                .collect(Collectors.toList());
    }

    private static List<String> writePermissions(Collection<Permission> permissions) {
        return permissions.stream().map(Permission::getPermissionName).collect(Collectors.toList());
    }

    public static List<com.xebialabs.deployit.engine.api.security.Permission> writeReferenceDataPermissions(Collection<Permission> values) {
        return values.stream()
                .map(p -> new com.xebialabs.deployit.engine.api.security.Permission(
                        p.getPermissionName(),
                        p.getLevel().name(),
                        p.getRoot() != null ? p.getRoot().getRootNodeName() : null))
                .collect(Collectors.toList());
    }
}
