/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Component;

@Component
@Provider
public class WorkdirInjectorFactory
extends InjectorFactoryImpl {
    private static final Logger logger = LoggerFactory.getLogger(WorkdirInjectorFactory.class);

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return new WorkdirMethodInjector(method, factory);
    }

    public static class WorkdirMethodInjector
    extends MethodInjectorImpl {
        private final ResourceLocator resourceLocator;

        public WorkdirMethodInjector(ResourceLocator resourceLocator, ResteasyProviderFactory factory) {
            super(resourceLocator, factory);
            this.resourceLocator = resourceLocator;
        }

        public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
            Object realMethod2;
            Workdir.Clean clean = null;
            try {
                realMethod2 = AopUtils.getTargetClass((Object)resource).getMethod(this.method.getMethod().getName(), this.resourceLocator.getMethod().getParameterTypes());
                if (((AccessibleObject)realMethod2).isAnnotationPresent(Workdir.class)) {
                    Workdir workdirAnnotation = ((Method)realMethod2).getAnnotation(Workdir.class);
                    String prefix = workdirAnnotation.prefix();
                    clean = workdirAnnotation.clean();
                    logger.trace("Initializing WorkDir for method [{}] with prefix [{}]", (Object)this.method, (Object)prefix);
                    WorkdirHolder.initWorkdir(prefix);
                }
            }
            catch (NoSuchMethodException realMethod2) {
                // empty catch block
            }
            try {
                realMethod2 = super.invoke(request, httpResponse, resource);
                return realMethod2;
            }
            catch (RuntimeException e) {
                if (clean == Workdir.Clean.ONLY_ON_EXCEPTION) {
                    WorkdirHolder.get().delete();
                }
                throw e;
            }
            finally {
                if (clean == Workdir.Clean.ALWAYS) {
                    WorkdirHolder.get().delete();
                }
                WorkdirHolder.clear();
            }
        }
    }
}

