package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.repository.WorkDir;

public class WorkDirTemplate {

    public static <T> T cleanOnException(Callback<T> c) {
        WorkDir workDir = WorkdirHolder.get();
        try {
            return c.doWithWorkdir(workDir);
        } catch (RuntimeException e) {
            workDir.delete();
            throw e;
        }
    }

    public static <T> T cleanOnFinally(Callback<T> c) {
        return cleanOnFinally(WorkdirHolder.get(), c);
    }

    public static <T> T cleanOnFinally(WorkDir workDir, Callback<T> c) {
        if (workDir == null) {
            return c.doWithWorkdir(workDir);
        } else {
            try {
                return c.doWithWorkdir(workDir);
            } finally {
                workDir.delete();
            }
        }
    }

    public interface Callback<T> {
        T doWithWorkdir(WorkDir workDir);
    }
}
