/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.spi.event.PermissionGrantedEvent;
import com.xebialabs.deployit.engine.spi.event.PermissionRevokedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class PermissionResource
extends AbstractSecuredResource
implements PermissionService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;

    private static Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    private HashMap<String, Collection<String>> getStringCollectionHashMap(Map<String, List<String>> stringStringMultimap) {
        return new HashMap<String, Collection<String>>(stringStringMultimap.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public Map<String, Collection<String>> getGrantedPermissions(String roleName) {
        Role role = this.roleService.getRoleForRoleName(roleName);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(role));
    }

    public Map<String, Collection<String>> getGrantedPermissionsById(String roleId) {
        Role role = this.roleService.getRoleForRoleId(roleId);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(role));
    }

    public Map<String, Collection<String>> getMyGrantedPermissions() {
        Authentication authentication = Permissions.getAuthentication();
        List roles = this.roleService.getRolesFor(authentication);
        return this.getStringCollectionHashMap(this.permissionLister.listPermissions(roles));
    }

    public boolean isGranted(String permissionName, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Permission permission = Permission.find((String)permissionName);
        Map rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        return rolePermissionMultimap.computeIfAbsent(role, r -> new HashSet()).contains(permission);
    }

    public void grant(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Map rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet()).add(PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionGrantedEvent(id, roleName, permission));
    }

    public void revoke(String permission, String id, String roleName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        Role role = this.roleService.getRoleForRoleName(roleName);
        Map rolePermissions = this.permissionEditor.readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet()).remove(PermissionResource.getPermission(permission));
        this.permissionEditor.editPermissions(id, rolePermissions);
        EventBusHolder.publish((Object)new PermissionRevokedEvent(id, roleName, permission));
    }

    public boolean isGrantedToMe(String permission, String id) {
        return PermissionResource.getPermission(permission).getPermissionHandler().hasPermission(id);
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

