/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.core.api.dto.LicenseDto;
import com.xebialabs.deployit.core.api.dto.LicensedCiUsageDto;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;

@Controller
public class ConfigurationResource
implements ConfigurationService {
    private final ServerConfiguration config;
    private final LicenseService licenseService;
    @Value(value="${xl.task.in-process-worker}")
    private Boolean inProcessWorker;

    @Autowired
    public ConfigurationResource(ServerConfiguration config, LicenseService licenseService) {
        this.config = config;
        this.licenseService = licenseService;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("active.user.sessions", Boolean.toString(this.config.isActiveUserSessions()));
        properties.put("client.session.timeout.minutes", Integer.toString(this.config.getClientSessionTimeoutMinutes()));
        properties.put("client.session.remember.enabled", Boolean.toString(this.config.isClientSessionRememberEnabled()));
        properties.put("client.automatically.map.all.deployables", Boolean.toString(this.config.isClientAutomaticallyMapAllDeployables()));
        properties.put("client.automatically.map.all.deployables.on.initial", Boolean.toString(this.config.isClientAutomaticallyMapAllDeployablesOnInitial()));
        properties.put("client.automatically.map.all.deployables.on.update", Boolean.toString(this.config.isClientAutomaticallyMapAllDeployablesOnUpdate()));
        properties.put("client.server_poll.delay", Integer.toString(this.config.getClientServerPollDelay()));
        properties.put("xl.task.in-process-worker", Boolean.toString(this.inProcessWorker));
        return properties;
    }

    public LicenseDto getLicenseInfo() {
        LicenseCiCounter.LicensedCiUse[] ciUses;
        License license = this.licenseService.getLicense();
        LicenseDto licenseDto = new LicenseDto(license.getStringValue(LicenseProperty.PRODUCT), license.getStringValue(LicenseProperty.LICENSED_TO), license.getStringValue(LicenseProperty.CONTACT));
        String expiresAfter = license.getStringValue(LicenseProperty.EXPIRES_AFTER);
        licenseDto.setExpiresAfter(expiresAfter);
        for (LicenseCiCounter.LicensedCiUse ciUse : ciUses = this.licenseService.getCounter().licensedCisInUse()) {
            licenseDto.getLicensedCiUsages().add(new LicensedCiUsageDto(ciUse.type().toString(), ciUse.allowedAmount(), ciUse.actualAmount()));
        }
        licenseDto.setSupportPolicy(license.getStringValue(LicenseProperty.SUPPORT_POLICY));
        licenseDto.setEdition(license.getStringValue(LicenseProperty.EDITION));
        List plugins = license.getListValue(LicenseProperty.LICENSED_PLUGINS);
        licenseDto.setMaxUsers(license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS));
        licenseDto.getLicensedPlugins().addAll(plugins);
        return licenseDto;
    }
}

