package com.xebialabs.deployit.core.rest.secured;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.READ;

/**
 *
 */
public abstract class AbstractSecuredResource {

    @Autowired
    private RoleService roleService;

    protected void checkPermission(Permission permission) {
        checkPermission(permission, null);
    }

    protected void checkPermissions(Permission... permissions) {
        checkPermissions(permissions, null);
    }

    protected void checkPermission(Permission permission, String id) {
        if (!permission.getPermissionHandler().hasPermission(id)) {
            throw PermissionDeniedException.forPermission(permission, id);
        }
    }

    protected void checkReadPermission(String id) {
        if (!roleService.isReadOnlyAdmin()) {
            checkPermission(READ, id);
        }
    }

    protected void checkPermissions(Permission[] permissions, String id) {
        if (Strings.isBlank(id)) {
            if (!PermissionHelper.hasPermission(permissions)) {
                throw PermissionDeniedException.forPermissions(Arrays.asList(permissions), id);
            }
        } else if (!PermissionHelper.hasPermission(permissions, id)) {
            throw PermissionDeniedException.forPermissions(Arrays.asList(permissions), id);
        }
    }

    protected boolean hasPermission(Permission permission) {
        return hasPermission(permission, null);
    }

    protected boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }

    protected boolean hasReadPermission(String id) {
        return READ.getPermissionHandler().hasPermission(id) || roleService.isReadOnlyAdmin();
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}
