/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Properties;

public class Worker
implements Serializable {
    private static final String AJP_13 = "ajp13";
    private String name;
    private String address;
    private int port;
    private int lbFactor = 1;
    private int cacheSize;
    private int cacheTimeout;
    private boolean socketKeepAlive = false;
    private int socketTimeout;
    private String type = "ajp13";

    public Worker() {
    }

    public Worker(String name, String address, int port) {
        Preconditions.checkNotNull((Object)name, (Object)"Worker name is null");
        this.name = this.convert(name);
        this.address = address;
        this.port = port;
    }

    public Worker(String name, Properties properties) {
        this.name = name;
        this.address = this.getStringProperty("host", properties, "0.0.0.0");
        this.type = this.getStringProperty("type", properties, AJP_13);
        this.port = Integer.parseInt(properties.getProperty("worker." + name + ".port", "8009"));
        this.cacheSize = this.getIntProperty("cachesize", properties);
        this.cacheTimeout = this.getIntProperty("cache_timeout", properties);
        this.socketKeepAlive = this.getIntProperty("socket_keepalive", properties) > 0;
        this.socketTimeout = this.getIntProperty("socket_timeout", properties);
    }

    private String getStringProperty(String attributeName, Properties properties, String defaultValue) {
        return properties.getProperty("worker." + this.name + "." + attributeName, defaultValue);
    }

    private int getIntProperty(String attributeName, Properties properties) {
        return Integer.parseInt(properties.getProperty("worker." + this.name + "." + attributeName, "0"));
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public int getLbFactor() {
        return this.lbFactor;
    }

    public void setLbFactor(int lbFactor) {
        this.lbFactor = lbFactor;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Worker)) {
            return false;
        }
        Worker worker = (Worker)o;
        return this.name.equals(worker.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private String convert(String s) {
        return s.replace(' ', '.');
    }
}

