/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.xebialabs.deployit.plugin.apache.modjk.step.Worker;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancer
implements Serializable {
    private final String name;
    private final Set<Worker> workers = new HashSet<Worker>();
    private final Set<String> workerNames = new HashSet<String>();
    private int stickySession = 1;

    public LoadBalancer(String name, Set<Worker> workers) {
        this.name = name;
        this.workers.addAll(workers);
    }

    public LoadBalancer(String name, Properties properties) {
        this.name = name;
        String bw = properties.getProperty("worker." + name + "." + "balance_workers", "");
        for (String w : bw.split(",")) {
            this.workerNames.add(w);
        }
        this.stickySession = Integer.parseInt(properties.getProperty("worker." + name + ".sticky_session", "1"));
    }

    public void addWorker(Worker w) {
        if (this.workerNames.contains(w.getName())) {
            this.workers.add(w);
        }
    }

    public Set<Worker> getWorkers() {
        return Collections.unmodifiableSet(this.workers);
    }

    public int getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(int stickySession) {
        this.stickySession = stickySession;
    }

    public String getWorkerNames() {
        return ExtendedStringUtils.join(this.workers, (Transformer)new Transformer(){

            public String transform(Object obj) {
                Worker worker = (Worker)obj;
                if (worker == null) {
                    return "XXX";
                }
                return worker.getName();
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

