/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.ci;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.ListenServer;
import com.xebialabs.deployit.ci.LoadBalancedServerAware;
import com.xebialabs.deployit.ci.LoadBalancingProtocol;
import com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.step.LoadBalancer;
import com.xebialabs.deployit.plugin.apache.modjk.step.Worker;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem
public class ModJkApacheModuleConfigurationMapping
extends SourcePropertyOverridingMapping<ModJkApacheModuleConfiguration, ApacheHttpdServer> {
    @ConfigurationItemProperty(required=true, description="the virtual host associated with the modjk configuration")
    private String virtualHost;
    @ConfigurationItemProperty(description="Set of the targets - Tomcat or JBoss- implied in the load balancing")
    private Set<LoadBalancedServerAware> targets = Sets.newHashSet();
    @ConfigurationItemProperty(description="Prefix used to build the name of the worker, default LB-")
    private String loadBalancerPrefixName = "LB-";

    public Set<Worker> getWorkers() {
        if (this.targets.isEmpty()) {
            throw new ResolutionException("Select at least one target");
        }
        HashSet workers = Sets.newHashSet();
        for (LoadBalancedServerAware target : this.targets) {
            List protocolList = target.getSupportedProtocols();
            if (!protocolList.contains(LoadBalancingProtocol.AJP)) continue;
            List serverList = target.getLoadBalancedServers(LoadBalancingProtocol.AJP);
            for (ListenServer server : serverList) {
                workers.add(this.update(new Worker(server.getLabel(), server.getHost().getAddress(), server.getListenPort())));
            }
        }
        return workers;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerPrefixName + this.getVirtualHost().replace(':', '_').replace('*', '_');
    }

    public LoadBalancer getLoadBalancer() {
        LoadBalancer lb = new LoadBalancer(this.getLoadBalancerName(), this.getWorkers());
        lb.setStickySession(((ModJkApacheModuleConfiguration)((Object)this.getSource())).isStickySession() ? 1 : 0);
        return lb;
    }

    protected Worker update(Worker worker) {
        ModJkApacheModuleConfiguration configuration = (ModJkApacheModuleConfiguration)((Object)this.getSource());
        worker.setCacheSize(configuration.getCacheSize());
        worker.setCacheTimeout(configuration.getCacheTimeout());
        worker.setSocketKeepAlive(configuration.isSocketKeepAlive());
        worker.setSocketTimeout(configuration.getSocketTimeout());
        return worker;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public Set<LoadBalancedServerAware> getTargets() {
        return this.targets;
    }

    public void setTargets(Set<LoadBalancedServerAware> targets) {
        this.targets = targets;
    }
}

