package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfigurationMapping;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DeleteModkJKConfigFileStep extends BaseModkJKConfigFileStep implements Step {

	public DeleteModkJKConfigFileStep(ApacheHttpdServer webServer, ModJkApacheModuleConfiguration jkConfiguration, ModJkApacheModuleConfigurationMapping mapping) {
		super(jkConfiguration, webServer, mapping);
		setDescription("Remove mod_jk Apache Plugin configuration file on " + webServer.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = this.apacheHttpdServer.connectToAdminHost();
		try {
			ctx.logOutput("Removing mod_jk workers for " + loadbalancerName + " in configuration file in " + apacheHttpdServer.getHost() + ":" + workerFile);
			loadWorkerContent(hostSession, false);
			String workersConfiguration = resolveWorkerPropertiesFile();
			HostFile workerConfigurationHostFile = hostSession.getFile(workerFile);
			workerConfigurationHostFile.getParentFile().mkdirs();
			workerConfigurationHostFile.put(IOUtils.toInputStream(workersConfiguration), workersConfiguration.length());


			String configFileWritePath = getVirtualHostConfigFilePath(hostSession);
			ctx.logOutput("Removing Apache HTTPD VirtualHost configuration file at " + configFileWritePath);

			boolean result = hostSession.getFile(configFileWritePath).delete();

			if (this.workers.isEmpty() && this.loadbalancers.isEmpty()) {
				//No more loadbalancer configured, remove all files      *
				ctx.logOutput("No more loadbalancer configured, remove mod_jk configuration files");
				result = result && hostSession.getFile(workerFile).delete();
				//hostSession.getFile(mountConfigurationFilePath).delete();
				result = result && hostSession.getFile(modkjkConfigFilePath).delete();
			}

			return result;
		} finally {
			hostSession.close();
		}
	}

	private static Logger logger = Logger.getLogger(DeleteModkJKConfigFileStep.class);

}
