package com.xebialabs.deployit.plugin.apache.modjk.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.apache.modjk.mapper.ModJkApacheModuleConfigurationToApacheHttpdServerMapper;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;

import java.util.List;

public class ModJkApacheModuleRunbook extends SingleTypeHandlingRunBook<Deployment> implements RunBook {

	public ModJkApacheModuleRunbook() {
		super(Deployment.class);
	}

	@Override
	protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
		try {
			ModJkApacheModuleConfigurationToApacheHttpdServerMapper pluginConfigMapper = new ModJkApacheModuleConfigurationToApacheHttpdServerMapper(change);
			StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);

			staticContentMapper.generateDeletionSteps(steps);
			pluginConfigMapper.generateDeletionSteps(steps);

			staticContentMapper.generateAdditionSteps(steps);
			pluginConfigMapper.generateAdditionSteps(steps);

		} catch (Exception e) {
			e.printStackTrace();
		}

	}
}
