/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfigurationMapping;
import com.xebialabs.deployit.plugin.apache.modjk.step.BaseModkJKConfigFileStep;
import com.xebialabs.deployit.plugin.apache.modjk.step.LoadBalancer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CreateModkJKConfigFileStep
extends BaseModkJKConfigFileStep
implements Step {
    private static final String DEFAULT_VHOST_MODJK_PROPERTIES_TEMPLATE = "com/xebialabs/deployit/plugin/apache/modjk/apache_vhost.conf.vm";
    private String lbWorker;
    private List<String> jkMounts;
    private List<String> jkUnmounts;

    public CreateModkJKConfigFileStep(ApacheHttpdServer apacheHttpdServer, ModJkApacheModuleConfiguration pluginConfiguration, ModJkApacheModuleConfigurationMapping mapping) {
        super(pluginConfiguration, apacheHttpdServer, mapping);
        this.setDescription("Generate mod_jk Apache Plugin configuration file on " + this.apacheHttpdServer.getHost());
        this.jkMounts = pluginConfiguration.getUrlMounts();
        this.jkUnmounts = pluginConfiguration.getUrlUnmounts();
        this.lbWorker = ((LoadBalancer)this.loadbalancers.iterator().next()).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.apacheHttpdServer.connectToAdminHost();
        try {
            HostFile modjkConfigHostFile = hostSession.getFile(this.modkjkConfigFilePath);
            if (!modjkConfigHostFile.exists()) {
                ctx.logOutput("Generating mod_jk configuration file at " + this.modkjkConfigFilePath + " on " + this.apacheHttpdServer.getHost());
                String modJKConfiguration = this.resolveModJkPropertiesFile();
                modjkConfigHostFile.getParentFile().mkdirs();
                modjkConfigHostFile.put(IOUtils.toInputStream((String)modJKConfiguration), (long)modJKConfiguration.length());
            }
            ctx.logOutput("Generating mod_jk workers for " + this.loadbalancerName + " in configuration file in " + this.apacheHttpdServer.getHost() + ":" + this.workerFile);
            this.loadWorkerContent(hostSession, true);
            String workersConfiguration = this.resolveWorkerPropertiesFile();
            HostFile workerConfigurationHostFile = hostSession.getFile(this.workerFile);
            workerConfigurationHostFile.getParentFile().mkdirs();
            workerConfigurationHostFile.put(IOUtils.toInputStream((String)workersConfiguration), (long)workersConfiguration.length());
            ctx.logOutput("Generating apache configuration ");
            String configFileWritePath = this.getVirtualHostConfigFilePath(hostSession);
            ctx.logOutput("Creating Apache HTTPD VirtualHost configuration file at " + configFileWritePath);
            HostFile vhostConfFile = hostSession.getFile(configFileWritePath);
            String virtualHostDefinition = this.resolveVirtualHostApacheConfigurationFile();
            vhostConfFile.put(IOUtils.toInputStream((String)virtualHostDefinition), (long)virtualHostDefinition.length());
            boolean bl = true;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }

    protected String resolveVirtualHostApacheConfigurationFile() {
        Map<String, Object> map = this.getVelocityContext();
        map.put("apachevirtualhostdefinition", this.getApacheVirtualHostDefinition());
        map.put("apachehttpdserver", this.apacheHttpdServer);
        map.put("jkMounts", this.jkMounts);
        map.put("jkUnmounts", this.jkUnmounts);
        map.put("path", this.lbWorker);
        String evaluatedScript = this.generateWithVelocity(DEFAULT_VHOST_MODJK_PROPERTIES_TEMPLATE, map);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("virtual host configuration:" + evaluatedScript));
        }
        return evaluatedScript;
    }
}

