/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfigurationMapping;
import com.xebialabs.deployit.plugin.apache.modjk.step.BaseModkJKConfigFileStep;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DeleteModkJKConfigFileStep
extends BaseModkJKConfigFileStep
implements Step {
    private static Logger logger = Logger.getLogger(DeleteModkJKConfigFileStep.class);

    public DeleteModkJKConfigFileStep(ApacheHttpdServer webServer, ModJkApacheModuleConfiguration jkConfiguration, ModJkApacheModuleConfigurationMapping mapping) {
        super(jkConfiguration, webServer, mapping);
        this.setDescription("Remove mod_jk Apache Plugin configuration file on " + webServer.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.apacheHttpdServer.connectToAdminHost();
        try {
            ctx.logOutput("Removing mod_jk workers for " + this.loadbalancerName + " in configuration file in " + this.apacheHttpdServer.getHost() + ":" + this.workerFile);
            this.loadWorkerContent(hostSession, false);
            String workersConfiguration = this.resolveWorkerPropertiesFile();
            HostFile workerConfigurationHostFile = hostSession.getFile(this.workerFile);
            workerConfigurationHostFile.getParentFile().mkdirs();
            workerConfigurationHostFile.put(IOUtils.toInputStream((String)workersConfiguration), (long)workersConfiguration.length());
            String configFileWritePath = this.getVirtualHostConfigFilePath(hostSession);
            ctx.logOutput("Removing Apache HTTPD VirtualHost configuration file at " + configFileWritePath);
            boolean result = hostSession.getFile(configFileWritePath).delete();
            if (this.workers.isEmpty() && this.loadbalancers.isEmpty()) {
                ctx.logOutput("No more loadbalancer configured, remove mod_jk configuration files");
                result = result && hostSession.getFile(this.workerFile).delete();
                result = result && hostSession.getFile(this.modkjkConfigFilePath).delete();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }
}

