/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.ApacheVirtualHostDefinition;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModule;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfiguration;
import com.xebialabs.deployit.plugin.apache.modjk.ci.ModJkApacheModuleConfigurationMapping;
import com.xebialabs.deployit.plugin.apache.modjk.step.LoadBalancer;
import com.xebialabs.deployit.plugin.apache.modjk.step.Worker;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModkJKConfigFileStep
implements Step {
    private static final String DEFAULT_MODJK_PROPERTIES_TEMPLATE = "com/xebialabs/deployit/plugin/apache/modjk/mod_jk.properties.vm";
    private static final String DEFAULT_WORKER_PROPERTIES_TEMPLATE = "com/xebialabs/deployit/plugin/apache/modjk/workers.properties.vm";
    protected ModJkApacheModuleConfiguration pluginConfiguration;
    protected ApacheHttpdServer apacheHttpdServer;
    protected Set<Worker> workers;
    protected Set<LoadBalancer> loadbalancers = new HashSet<LoadBalancer>();
    protected String modkjkConfigFilePath;
    protected String loadbalancerName;
    private ModJkApacheModule modJkApacheModule;
    protected String description;
    protected String virtualHost;
    protected String workerFile;
    static Logger logger = Logger.getLogger(BaseModkJKConfigFileStep.class);

    protected BaseModkJKConfigFileStep(ModJkApacheModuleConfiguration pluginConfiguration, ApacheHttpdServer apacheHttpdServer, ModJkApacheModuleConfigurationMapping mapping) {
        this.pluginConfiguration = pluginConfiguration;
        this.apacheHttpdServer = apacheHttpdServer;
        this.workers = mapping.getWorkers();
        this.loadbalancers.add(mapping.getLoadBalancer());
        this.modkjkConfigFilePath = this.apacheHttpdServer.getConfigurationLocation() + this.apacheHttpdServer.getHost().getOperatingSystemFamily().getFileSeparator() + "mod_jk.conf";
        this.loadbalancerName = mapping.getLoadBalancerName();
        this.modJkApacheModule = (ModJkApacheModule)this.apacheHttpdServer.getModule(ModJkApacheModule.class);
        if (this.modJkApacheModule == null) {
            throw new IllegalArgumentException("The targeted Apache Server is not configured with a Modjk Apache Module.");
        }
        this.workerFile = this.modJkApacheModule.getJkWorkerFile();
        this.virtualHost = mapping.getVirtualHost();
        if (StringUtils.isEmpty((String)this.virtualHost)) {
            throw new IllegalArgumentException("The virtual host definition cannot be empty.");
        }
    }

    protected void loadWorkerContent(HostSession hostSession, boolean createMode) {
        HostFile hostFile = hostSession.getFile(this.workerFile);
        HashMap<String, Worker> workers = new HashMap<String, Worker>();
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        this.parseWorkerPropertyFile(hostFile, workers, loadBalancers);
        if (createMode) {
            this.loadbalancers.addAll(loadBalancers.values());
            this.workers.addAll(workers.values());
        } else {
            loadBalancers.values().removeAll(this.loadbalancers);
            this.loadbalancers.clear();
            this.loadbalancers.addAll(loadBalancers.values());
            workers.values().removeAll(this.workers);
            this.workers.clear();
            for (LoadBalancer lb : this.loadbalancers) {
                this.workers.addAll(lb.getWorkers());
            }
        }
    }

    private void parseWorkerPropertyFile(HostFile hostFile, Map<String, Worker> workers, Map<String, LoadBalancer> loadBalancers) {
        if (!hostFile.exists()) {
            return;
        }
        InputStream inputStream = hostFile.get();
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Object key : properties.keySet()) {
            String k = (String)key;
            if (!k.startsWith("worker.") || !k.endsWith(".type")) continue;
            String name = k.substring("worker.".length(), k.length() - ".type".length());
            String type = properties.getProperty(k);
            if ("lb".equals(type)) {
                loadBalancers.put(name, new LoadBalancer(name, properties));
                continue;
            }
            if (!"ajp13".equals(type)) continue;
            workers.put(name, new Worker(name, properties));
        }
        for (Worker w : workers.values()) {
            for (LoadBalancer lb : loadBalancers.values()) {
                lb.addWorker(w);
            }
        }
    }

    protected String resolveModJkPropertiesFile() {
        String evaluatedScript = this.generateWithVelocity(DEFAULT_MODJK_PROPERTIES_TEMPLATE, this.getVelocityContext());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("mod_jk properties configuration:" + evaluatedScript));
        }
        return evaluatedScript;
    }

    protected String generateWithVelocity(String templatePath, Map<String, Object> velocityContext) {
        String evaluatedScript;
        InputStream scriptIn;
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.init();
        }
        catch (Exception exc) {
            throw new IllegalStateException("Cannot initialize Velocity templating engine", exc);
        }
        VelocityContext vc = new VelocityContext(velocityContext);
        ClassPathResource scriptResource = new ClassPathResource(templatePath);
        try {
            scriptIn = scriptResource.getInputStream();
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot read script template resource " + templatePath, exc);
        }
        try {
            StringWriter evaluatedTemplateWriter = new StringWriter();
            ve.evaluate((Context)vc, (Writer)evaluatedTemplateWriter, " ", (Reader)new InputStreamReader(scriptIn, "UTF-8"));
            evaluatedScript = evaluatedTemplateWriter.getBuffer().toString();
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot evaluate script template resource " + templatePath, exc);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptIn);
        }
        return evaluatedScript;
    }

    protected String resolveWorkerPropertiesFile() {
        String evaluatedScript = this.generateWithVelocity(DEFAULT_WORKER_PROPERTIES_TEMPLATE, this.getVelocityContext());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("worker properties configuration:" + evaluatedScript));
        }
        return evaluatedScript;
    }

    protected Map<String, Object> getVelocityContext() {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("workersFile", this.workerFile);
        velocityContext.put("workers", this.workers);
        velocityContext.put("loadbalancers", this.loadbalancers);
        velocityContext.put("loadbalancerNames", this.getLoadBalancerNames());
        velocityContext.put("pluginConfiguration", (Object)this.pluginConfiguration);
        velocityContext.put("modjk", (Object)this.modJkApacheModule);
        return velocityContext;
    }

    public String getLoadBalancerNames() {
        return ExtendedStringUtils.join(this.loadbalancers, (Transformer)new Transformer(){

            public String transform(Object obj) {
                LoadBalancer loadBalancer = (LoadBalancer)obj;
                if (loadBalancer == null) {
                    return "XXX";
                }
                return loadBalancer.getName();
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected String getVirtualHostConfigFilePath(HostSession hostSession) {
        ApacheVirtualHostDefinition definition = this.getApacheVirtualHostDefinition();
        String configLocationWrite = this.apacheHttpdServer.getConfigurationLocation();
        HostFile configLocationWriteFile = hostSession.getFile(configLocationWrite);
        String configFileWritePath = configLocationWriteFile.isDirectory() ? configLocationWrite + hostSession.getHostOperatingSystem().getFileSeparator() + definition.getFileName() : configLocationWrite;
        return configFileWritePath;
    }

    protected ApacheVirtualHostDefinition getApacheVirtualHostDefinition() {
        return new ApacheVirtualHostDefinition(this.virtualHost, this.apacheHttpdServer.getHtdocsLocation(), this.apacheHttpdServer.getHost().getOperatingSystemFamily(), null);
    }
}

