/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.modjk.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.plugin.apache.modjk.ci.LogLevel;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="An abstraction of Apache modk_jk Configuration. It is used to generate the configuration file which is included in the Apache main httpd.conf file")
public class ModJkApacheModuleConfiguration
extends BaseConfigurationItem
implements MiddlewareResource {
    @ConfigurationItemProperty(required=true, identifying=true, description="used to identify the modjk configuration")
    private String configurationName;
    @ConfigurationItemProperty(description="Comma separated list of  mounted URL in the mod_jk")
    private String urlMounts;
    @ConfigurationItemProperty(description="Comma separated list of unmounted URL  in the mod_jk")
    private String urlUnmounts;
    @ConfigurationItemProperty(description="handle jkStatus configuration, default false")
    private boolean jkstatus = false;
    @ConfigurationItemProperty(description="handle jkStatus log level, eg Error, default is Info")
    private LogLevel jkLogLevel = LogLevel.Info;
    @ConfigurationItemProperty(description="Configure the date/time format found on mod_jk logfile, default is [%a %b %d %H:%M:%S %Y]")
    private String jkLogStampFormat = "[%a %b %d %H:%M:%S %Y]";
    @ConfigurationItemProperty(description="Allow you to set many forwarding options which will enable (+) or disable (-) following option")
    private String JkOptions;
    @ConfigurationItemProperty(description="Cachesize defines the number of connections made to the AJP backend that are maintained as a connection pool. It will limit the number of those connection that each web server child process can make.")
    private int cacheSize;
    @ConfigurationItemProperty(description="Cache timeout property should be used with cachesize to specify how to time JK should keep an open socket in cache before closing it. This property should be used to reduce the number of threads on the Tomcat web server.")
    private int cacheTimeout;
    @ConfigurationItemProperty(description="This directive should be used when you have a firewall between your webserver and the Tomcat engine, who tend to drop inactive connections.")
    private boolean socketKeepAlive;
    @ConfigurationItemProperty(description="Socket timeout in seconds used for the communication channel between JK and remote host, default 0")
    private int socketTimeout = 0;
    @ConfigurationItemProperty(description="Specifies whether requests with SESSION ID's should be routed back to the same Tomcat worker, default True")
    private boolean stickySession = true;

    public List<String> getUrlMounts() {
        return this.splitToURLPrefix(this.urlMounts);
    }

    public void setUrlMounts(String urlMounts) {
        this.urlMounts = urlMounts;
    }

    public void setUrlUnmounts(String urlUnmounts) {
        this.urlUnmounts = urlUnmounts;
    }

    public List<String> getUrlUnmounts() {
        return this.splitToURLPrefix(this.urlUnmounts);
    }

    public boolean isJkstatus() {
        return this.jkstatus;
    }

    public void setJkstatus(boolean jkstatus) {
        this.jkstatus = jkstatus;
    }

    public LogLevel getJkLogLevel() {
        return this.jkLogLevel;
    }

    public void setJkLogLevel(LogLevel jkLogLevel) {
        this.jkLogLevel = jkLogLevel;
    }

    public String getJkLogStampFormat() {
        return this.jkLogStampFormat;
    }

    public void setJkLogStampFormat(String jkLogStampFormat) {
        this.jkLogStampFormat = jkLogStampFormat;
    }

    public String getJkOptions() {
        return this.JkOptions;
    }

    public void setJkOptions(String jkOptions) {
        this.JkOptions = jkOptions;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isStickySession() {
        return this.stickySession;
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    private List<String> splitToURLPrefix(String commaseparatedlist) {
        if (StringUtils.isEmpty((String)commaseparatedlist)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])StrTokenizer.getCSVInstance((String)commaseparatedlist).getTokenArray());
    }
}

