/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemDescription;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.StaticContentMapping;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;

@ConfigurationItem(description="A standard Apache 2 installation.", category="middleware", targetForMappingTypes={StaticContentMapping.class})
public class ApacheHttpdServer
extends BaseConfigurationItem {
    @ConfigurationItemDescription
    private String description;
    @ConfigurationItemProperty(required=true, description="The host the web server is installed on")
    private Host host;
    @ConfigurationItemProperty(required=true, label="Apache Control Path", description="The path of the executable that will restart apache. Valid examples; /usr/sbin/apachectl")
    private String apachectlPath;
    @ConfigurationItemProperty(required=true, description="The location where deployit will generate apache httpd.conf fragment files.")
    private String configurationLocation;
    @ConfigurationItemProperty(required=true, label=" Ht Docs Location", description="The location where deployit will create a directory (based on the vhost name) where static content will be placed.")
    private String htdocsLocation;
    @ConfigurationItemProperty(required=true, description="The location where deployit will create a directory where access log will be placed.")
    private String accessLogLocation;
    @ConfigurationItemProperty(required=true, description="The location where deployit will create a directory where error log will be placed.")
    private String errorLogLocation;

    public HostSession connectToAdminHost() {
        return HostSessionFactory.getHostSession((Host)this.host);
    }

    public String getConfFilePathForVirtualHost(String virtualHost) {
        StringBuilder confFilePath = new StringBuilder();
        confFilePath.append(this.getConfigurationLocation());
        confFilePath.append(this.getHost().getFileSeparator());
        confFilePath.append(virtualHost.replace(':', '_'));
        confFilePath.append(".conf");
        return confFilePath.toString();
    }

    public String getHtdocsDirPathForVirtualHost(String virtualHost) {
        StringBuilder htdocsDirPath = new StringBuilder();
        htdocsDirPath.append(this.getHtdocsLocation());
        htdocsDirPath.append(this.getHost().getFileSeparator());
        htdocsDirPath.append(virtualHost.replace(':', '_'));
        return htdocsDirPath.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getApachectlPath() {
        return this.apachectlPath;
    }

    public void setApachectlPath(String apachectlPath) {
        this.apachectlPath = apachectlPath;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getHtdocsLocation() {
        return this.htdocsLocation;
    }

    public void setHtdocsLocation(String htdocsLocation) {
        this.htdocsLocation = htdocsLocation;
    }

    public String getAccessLogLocation() {
        return this.accessLogLocation;
    }

    public void setAccessLogLocation(String accessLogLocation) {
        this.accessLogLocation = accessLogLocation;
    }

    public String getErrorLogLocation() {
        return this.errorLogLocation;
    }

    public void setErrorLogLocation(String errorLogLocation) {
        this.errorLogLocation = errorLogLocation;
    }
}

