/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.util.ExtendedResourceUtils;
import com.xebialabs.deployit.util.TemplateResolver;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostDefinition {
    private static String DEFAULT_APACHE_VHOST_TEMPLATE = "com/xebialabs/deployit/plugin/apache/httpd/step/apache_httpd_server_vhost_template.conf";
    private final Collection<? extends Object> existingContext;
    private String documentRoot;
    private String host;
    private String port;
    private String nameVirtualHost;
    private String fileName;
    private String vhostDefinition;

    public ApacheVirtualHostDefinition(String vhostDefinition, String htdocsLocation, OperatingSystemFamily osf, Collection<?> existingContext) throws ResolutionException {
        this.existingContext = existingContext;
        if (vhostDefinition == null || vhostDefinition.equals("")) {
            throw new ResolutionException("No vhost definition provided");
        }
        if (htdocsLocation == null || htdocsLocation.equals("")) {
            throw new ResolutionException("No htdocs provided");
        }
        int colonIndex = vhostDefinition.indexOf(58);
        if (colonIndex == -1 || colonIndex - 1 <= 0 || colonIndex + 1 >= vhostDefinition.length()) {
            throw new ResolutionException("'vhostDefinition' has a syntax error. Should be <hostname>:<port>. Currently is " + vhostDefinition);
        }
        this.host = vhostDefinition.substring(0, vhostDefinition.indexOf(58));
        this.port = vhostDefinition.substring(vhostDefinition.indexOf(58) + 1);
        this.nameVirtualHost = "*:" + this.port;
        String fileNameFriendlyPort = this.port.equals("*") ? "allports" : this.port;
        String fileNameFriendlyHost = this.host.equals("*") ? "allhosts" : this.host;
        String fileNameFriendlyVhost = fileNameFriendlyHost + "_" + fileNameFriendlyPort;
        this.fileName = fileNameFriendlyVhost + ".conf";
        this.documentRoot = htdocsLocation + osf.getFileSeparator() + fileNameFriendlyVhost;
        if (existingContext != null) {
            this.vhostDefinition = this.resolveVhostDefinition();
        }
    }

    protected String resolveVhostDefinition() {
        ArrayList<? extends Object> context = new ArrayList<Object>();
        context.addAll(this.existingContext);
        context.add(this);
        String template = ExtendedResourceUtils.toString((Resource)new ClassPathResource(DEFAULT_APACHE_VHOST_TEMPLATE));
        TemplateResolver r = new TemplateResolver(context);
        return r.resolveStrict(template);
    }

    public String toVirtualHostDefinition() {
        return this.vhostDefinition;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public void setDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
    }

    public String getNameVirtualHost() {
        return this.nameVirtualHost;
    }

    public void setNameVirtualHost(String nameVirtualHost) {
        this.nameVirtualHost = nameVirtualHost;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

