/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.mapper;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.StaticContent;
import com.xebialabs.deployit.ci.artifact.mapping.StaticContentMapping;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticContentToApacheHttpdServerMapper
extends StepGeneratingMapper<StaticContent, StaticContentMapping, ApacheHttpdServer> {
    public StaticContentToApacheHttpdServerMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(StaticContent newSource, StaticContentMapping newMapping, ApacheHttpdServer newTarget, List<Step> steps) {
        String vhost = (String)Preconditions.checkNotNull((Object)newMapping.getVirtualHost(), (Object)"No virtual host supplied");
        steps.add((Step)new CopyStep(Host.getLocalHost(), newSource.getLocation(), newTarget.getHost(), newTarget.getHtdocsDirPathForVirtualHost(vhost), true));
    }

    protected void generateDeletionStepsForDeletedMapping(StaticContent oldSource, StaticContentMapping oldMapping, ApacheHttpdServer oldTarget, List<Step> steps) {
        String vhost = (String)Preconditions.checkNotNull((Object)oldMapping.getVirtualHost(), (Object)"No virtual host supplied");
        steps.add((Step)new DeleteStep(oldTarget.getHost(), oldTarget.getHtdocsDirPathForVirtualHost(vhost)));
    }

    public void setDefaults(Deployment d, StaticContentMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
    }
}

