package com.xebialabs.deployit.engine.tasker

import java.util

import com.xebialabs.deployit.engine.api.execution.{BlockState, TaskExecutionState, TaskPackageDependency, TaskWithBlock}
import org.joda.time.DateTime

import scala.beans.BeanProperty

class TaskSummary(task: Task) extends TaskWithBlock with Serializable {

  @BeanProperty val id: TaskId = task.getId
  @BeanProperty val description: Description = task.getSpecification.getDescription
  @BeanProperty val owner: String = task.getOwner
  @BeanProperty val metadata: util.Map[String, String] = task.getSpecification.getMetadata
  @BeanProperty val startDate: DateTime = task.getStartDate
  @BeanProperty val completionDate: DateTime = task.getCompletionDate
  @BeanProperty val scheduledDate: DateTime = task.getScheduledDate
  @BeanProperty val failureCount: Int = task.getFailureCount
  @BeanProperty val state: TaskExecutionState = task.getState
  @BeanProperty val workerId: Integer = task.getWorkerId
  @BeanProperty val packageDependencies: util.List[TaskPackageDependency] = task.getSpecification.getPackageDependencies

  override def getBlock: BlockState = null

  override def getActiveBlocks: util.List[String] = null

}
