package com.xebialabs.deployit.engine.tasker.satellite.log

import java.time.Instant

import akka.actor.Actor
import com.xebialabs.deployit.engine.tasker.log.ExternalStepLogFactory
import com.xebialabs.deployit.engine.tasker.{BlockPath, TaskId}

class TaskStepLogger(externalStepLogFactory: ExternalStepLogFactory) extends Actor {
  import Messages._
  override def receive: Receive = {
    case _: StepLogStart =>
      sender() ! StepLogAck
    case msg: StepLogMessage =>
      externalStepLogFactory.append(msg.taskId, msg.stepPath, msg.timestamp, msg.failureCount, msg.message)
      sender() ! StepLogAck
    case _: StepLogEnd =>
      sender() ! StepLogAck
  }
}

object Messages {

  case class StepLogStart()

  case class StepLogMessage(taskId: TaskId, stepPath: BlockPath, timestamp: Instant, failureCount: Int, message: String)

  case class StepLogEnd()

  case object StepLogAck

}
