/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas.deployit;

import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityServerClientPool {
    static SecurityServerClientPool INSTANCE = new SecurityServerClientPool();
    static final String CLIENT_POOL_DEFAULT_SIZE = "1";
    private final int size;
    private final ExecutorService executorService;
    private final ThreadLocal<SecurityServerClient> securityServerClient = new ThreadLocal<SecurityServerClient>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SecurityServerClient initialValue() {
            Class<SecurityServerClient> clazz = SecurityServerClient.class;
            synchronized (SecurityServerClient.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return SecurityServerClientPool.this.newSecurityServerClient();
            }
        }
    };
    protected final Log log = LogFactory.getLog(this.getClass());

    public SecurityServerClientPool() {
        this.size = Integer.parseInt(new ClientResourceLocator("crowd.properties").getProperties().getProperty("crowd.client.pool", CLIENT_POOL_DEFAULT_SIZE));
        this.log.debug((Object)("crowd.client.pool size is " + this.size));
        this.executorService = Executors.newFixedThreadPool(this.size);
    }

    public SOAPPrincipal findPrincipalByToken(final String token) {
        try {
            return this.executorService.submit(new Callable<SOAPPrincipal>(){

                @Override
                public SOAPPrincipal call() throws Exception {
                    return ((SecurityServerClient)SecurityServerClientPool.this.securityServerClient.get()).findPrincipalByToken(token);
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String authenticatePrincipal(final UserAuthenticationContext context) {
        try {
            return this.executorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ((SecurityServerClient)SecurityServerClientPool.this.securityServerClient.get()).authenticatePrincipal(context);
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] findGroupMemberships(final String user) {
        try {
            return this.executorService.submit(new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    return ((SecurityServerClient)SecurityServerClientPool.this.securityServerClient.get()).findGroupMemberships(user);
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SecurityServerClient newSecurityServerClient() {
        this.log.debug((Object)(Thread.currentThread() + "\tinitializing a new SecurityServerClient"));
        long start = System.currentTimeMillis();
        SecurityServerClientImpl securityServerClient = new SecurityServerClientImpl((SoapClientProperties)SoapClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)new ClientResourceLocator("crowd.properties")));
        this.log.debug((Object)(Thread.currentThread() + "\tinitialized SecurityServerClient " + (System.currentTimeMillis() - start)));
        try {
            securityServerClient.getCookieInfo();
        }
        catch (Exception e) {
            this.log.error((Object)"initialization failed", (Throwable)e);
            throw new RuntimeException("initialValue for thread value, fails", e);
        }
        this.log.debug((Object)(Thread.currentThread() + "\tinitialized SecurityStub " + (System.currentTimeMillis() - start)));
        return securityServerClient;
    }
}

