/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas;

import com.atlassian.crowd.application.jaas.AbstractLoginModule;
import com.atlassian.crowd.application.jaas.CrowdGroup;
import com.atlassian.crowd.application.jaas.CrowdPrincipal;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;

public abstract class UserRolesLoginModule
extends AbstractLoginModule {
    protected String principalClassName = CrowdPrincipal.class.getName();
    protected String roleGroupClassName = CrowdGroup.class.getName();
    protected String roleClassName = CrowdPrincipal.class.getName();
    protected String roleGroupName = "Roles";
    protected boolean flatRoles = false;

    @Override
    protected Set authenticate(Map credentials) throws LoginException {
        return null;
    }

    @Override
    protected void preInitialise(Map moduleOptions) {
        super.preInitialise(moduleOptions);
        String temp = (String)moduleOptions.get("principalClassName");
        if (temp != null) {
            this.principalClassName = temp;
        }
        this.log.debug((Object)("principalClassName = " + this.principalClassName));
        temp = (String)moduleOptions.get("roleGroupClassName");
        if (temp != null) {
            this.roleGroupClassName = temp;
        }
        this.log.debug((Object)("roleGroupClassName = " + this.roleGroupClassName));
        this.roleClassName = this.principalClassName;
        temp = (String)moduleOptions.get("roleClassName");
        if (temp != null) {
            this.roleClassName = temp;
        }
        this.log.debug((Object)("roleClassName = " + this.roleClassName));
        temp = (String)moduleOptions.get("roleGroupName");
        if (temp != null) {
            this.roleGroupName = temp;
        }
        this.log.debug((Object)("roleGroupName = " + this.roleGroupName));
        this.flatRoles = "true".equalsIgnoreCase((String)moduleOptions.get("flatRoles"));
        this.log.debug((Object)("flatRoles = " + this.flatRoles));
    }

    protected Set createPrincipals(String user, Set roles) throws LoginException {
        this.log.debug((Object)String.format("create Principals %s, roles %s", user, roles));
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(UserRolesLoginModule.createPrincipal(this.principalClassName, user));
        if (roles != null) {
            if (this.flatRoles) {
                for (String role : roles) {
                    principals.add(UserRolesLoginModule.createPrincipal(this.roleClassName, role));
                }
            } else {
                Group group = (Group)UserRolesLoginModule.createPrincipal(this.roleGroupClassName, this.roleGroupName);
                for (String role : roles) {
                    group.addMember(UserRolesLoginModule.createPrincipal(this.roleClassName, role));
                }
                principals.add((Principal)group);
            }
        }
        this.log.debug(principals);
        return principals;
    }
}

