/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.service.grpc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import com.xebialabs.agatha.service.grpc.CrawlerQueueServiceTestStub;
import com.xebialabs.agatha.service.keyvaluestorage.KeyValueStorageMock;
import com.xebialabs.agatha.service.keyvaluestorage.KeyValueStorageService;
import com.xebialabs.agatha.shared.grpc.services.ingest.AckCrawlerUMMessageRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.AckCrawlerUMMessageResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.ArtefactDedupeUMMetadataRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.ArtefactDedupeUMMetadataResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerCredentialsPackage;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerEndpointServiceGrpc;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerQueueMessage;
import com.xebialabs.agatha.shared.grpc.services.ingest.DedupeMetadata;
import com.xebialabs.agatha.shared.grpc.services.ingest.PollCrawlerUMMessageRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.PollCrawlerUMMessageResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMDataRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMDataResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMMessageRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMMessageResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushProbeUMStatusRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushProbeUMStatusResponse;
import com.xebialabs.agatha.utils.StreamUtils;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerApiServiceTestStub
extends CrawlerEndpointServiceGrpc.CrawlerEndpointServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(CrawlerApiServiceTestStub.class);
    public final CrawlerQueueServiceTestStub queueService;
    public final KeyValueStorageService keyValueStorage;
    public static final String TENANT_ID = "testTenant";
    public static final String PLUGIN_ID = "testPlugin";
    private final ObjectMapper mapper;
    public String credentials;

    public CrawlerApiServiceTestStub(ObjectMapper mapper) {
        this.queueService = new CrawlerQueueServiceTestStub(mapper);
        this.keyValueStorage = new KeyValueStorageMock(mapper);
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new ProtobufModule());
    }

    public void pollUMMessage(PollCrawlerUMMessageRequest request, StreamObserver<PollCrawlerUMMessageResponse> responseObserver) {
        try {
            PollCrawlerUMMessageResponse.Builder responseBuilder = PollCrawlerUMMessageResponse.newBuilder();
            CrawlerQueueMessage queueMessage = this.queueService.pullMessage(request.getPluginId(), request.getQueue());
            if (queueMessage != null && queueMessage.getJson() != null && !queueMessage.getJson().isEmpty()) {
                responseBuilder.setTenantId(TENANT_ID).setMessage(queueMessage).setMessageId(queueMessage.getId());
                if (this.credentials != null) {
                    responseBuilder.setCredentialsPackage((CrawlerCredentialsPackage)this.mapper.readValue(this.credentials, CrawlerCredentialsPackage.class));
                }
            }
            this.callGrpcMethod(responseObserver, responseBuilder.build());
        }
        catch (IOException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void pushUMMessage(PushCrawlerUMMessageRequest request, StreamObserver<PushCrawlerUMMessageResponse> responseObserver) {
        try {
            this.queueService.publishMessage(request.getPluginId(), request.getQueue(), request.getMessage());
            this.callGrpcMethod(responseObserver, PushCrawlerUMMessageResponse.newBuilder().build());
        }
        catch (IOException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void ackUMMessage(AckCrawlerUMMessageRequest request, StreamObserver<AckCrawlerUMMessageResponse> responseObserver) {
        this.queueService.ackMessage(request.getPluginId(), request.getQueue(), request.getMessageId());
        this.callGrpcMethod(responseObserver, AckCrawlerUMMessageResponse.newBuilder().build());
    }

    public PushCrawlerUMDataResponse.Builder updateDedupeMetadataAndStatus(PushCrawlerUMDataRequest request) {
        String dedupeMetadataKey = this.keyValueStorage.makeDedupeMetadataKey(request.getTenantId(), request.getDataSourceType(), request.getPluginId(), request.getDataSourceId(), request.getArtefact().getDedupeMetadata().getArtefactId());
        Optional<DedupeMetadata> dedupeMetadata = this.keyValueStorage.getAs(dedupeMetadataKey, DedupeMetadata::newBuilder).map(DedupeMetadata.Builder::build);
        PushCrawlerUMDataResponse.Builder responseBuilder = PushCrawlerUMDataResponse.newBuilder();
        if (dedupeMetadata.isPresent() && dedupeMetadata.get().getVersion().equals(request.getArtefact().getVersion())) {
            responseBuilder.setIsKnown(true);
        } else {
            responseBuilder.setIsKnown(false);
        }
        this.keyValueStorage.put(dedupeMetadataKey, request.getArtefact().getDedupeMetadata());
        if (request.getCrawlerStatus() != null) {
            this.keyValueStorage.put(this.keyValueStorage.makeDataSourceStatusKey(request.getTenantId(), request.getPluginId(), request.getDataSourceId()), request.getCrawlerStatus());
        }
        return responseBuilder;
    }

    public void pushUMData(PushCrawlerUMDataRequest request, StreamObserver<PushCrawlerUMDataResponse> responseObserver) {
        PushCrawlerUMDataResponse.Builder responseBuilder = this.updateDedupeMetadataAndStatus(request);
        if (!responseBuilder.getIsKnown()) {
            String requestData = request.getArtefact().getData();
            String key = this.keyValueStorage.makeDataKey(request.getTenantId(), request.getDataSourceType(), request.getPluginId(), request.getDataSourceId(), request.getArtefact().getDedupeMetadata().getArtefactId());
            this.keyValueStorage.put(key, requestData);
        }
        this.callGrpcMethod(responseObserver, responseBuilder.build());
    }

    public StreamObserver<PushCrawlerUMDataRequest> pushUMDataStream(StreamObserver<PushCrawlerUMDataResponse> responseObserver) {
        return new DataStreamObserver(responseObserver);
    }

    public void pushProbeUMStatus(PushProbeUMStatusRequest request, StreamObserver<PushProbeUMStatusResponse> responseObserver) {
        this.keyValueStorage.put(this.keyValueStorage.makeDataSourceProbeResultKey(request.getTenantId(), request.getPluginId(), request.getDataSourceId(), request.getProbeId()), request.getProbeStatus());
        this.callGrpcMethod(responseObserver, PushProbeUMStatusResponse.newBuilder().build());
    }

    public void getArtefactDedupeUMMetadata(ArtefactDedupeUMMetadataRequest request, StreamObserver<ArtefactDedupeUMMetadataResponse> responseObserver) {
        responseObserver.onNext((Object)ArtefactDedupeUMMetadataResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    private <T> void callGrpcMethod(StreamObserver<T> streamObserver, T response) {
        streamObserver.onNext(response);
        streamObserver.onCompleted();
    }

    private class DataStreamObserver
    implements StreamObserver<PushCrawlerUMDataRequest> {
        WritableByteChannel writer;
        PushCrawlerUMDataRequest msgMeta;
        String fileId;
        StreamObserver<PushCrawlerUMDataResponse> responseObserver;

        private DataStreamObserver(StreamObserver<PushCrawlerUMDataResponse> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public void onNext(PushCrawlerUMDataRequest data) {
            this.callWithLimit(() -> {
                try {
                    if (this.msgMeta == null || this.writer == null) {
                        this.msgMeta = data;
                        this.fileId = CrawlerApiServiceTestStub.this.keyValueStorage.makeDataKey(data.getTenantId(), data.getDataSourceType(), data.getPluginId(), data.getDataSourceId(), data.getArtefact().getDedupeMetadata().getArtefactId());
                        this.writer = CrawlerApiServiceTestStub.this.keyValueStorage.getWriter(this.fileId).orElseThrow(() -> new RuntimeException(String.format("Cannot get writer to save stream! %s", data)));
                    }
                    StreamUtils.writeFully(this.writer, data.getArtefact().getDataBytes());
                }
                catch (IOException e) {
                    logger.error("Error writing chunk of data to output stream [{}]! {}", (Object)this.fileId, (Object)data);
                    this.responseObserver.onError((Throwable)e);
                }
                catch (Exception e) {
                    this.responseObserver.onError((Throwable)e);
                }
            });
        }

        public void onError(Throwable t) {
            logger.error("Error while getting crawler data as stream: {}", t);
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    logger.error("Error closing KV storage writer stream: {}", (Throwable)e);
                }
            }
            this.responseObserver.onError(t);
        }

        public void onCompleted() {
            if (this.writer != null) {
                logger.debug("Completed writing stream of input to KV storage: {}", (Object)this.fileId);
                try {
                    this.writer.close();
                    this.responseObserver.onNext((Object)PushCrawlerUMDataResponse.newBuilder().build());
                    this.responseObserver.onCompleted();
                }
                catch (IOException e) {
                    logger.error("Error closing KV storage writer stream: {}", (Throwable)e);
                    this.responseObserver.onError((Throwable)e);
                }
            }
        }

        private void callWithLimit(Runnable runnable) {
            runnable.run();
        }
    }
}

