/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.service.grpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerQueueMessage;
import com.xebialabs.agatha.shared.grpc.services.ingest.Queue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CrawlerQueueServiceTestStub {
    public Map<String, Map<Queue, Map<String, CrawlerMessage>>> stub = new HashMap<String, Map<Queue, Map<String, CrawlerMessage>>>();
    private ObjectMapper mapper;
    private volatile long messageIdCounter;

    public CrawlerQueueServiceTestStub(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void publishMessage(String pluginId, Queue queue, String messageJson) throws IOException {
        this.publishMessage(pluginId, queue, (CrawlerMessage)this.mapper.readValue(messageJson, CrawlerMessage.class));
    }

    public void publishMessage(String pluginId, Queue queue, CrawlerMessage message) {
        if (!this.stub.containsKey(pluginId)) {
            this.stub.put(pluginId, new HashMap());
        }
        if (!this.stub.get(pluginId).containsKey(queue)) {
            this.stub.get(pluginId).put(queue, new HashMap());
        }
        this.stub.get(pluginId).get(queue).put(this.prepareMessageId(pluginId, queue), message);
    }

    public CrawlerQueueMessage pullMessage(String pluginId, Queue queue) throws JsonProcessingException {
        if (this.stub.containsKey(pluginId) && this.stub.get(pluginId).containsKey(queue) && !this.stub.get(pluginId).get(queue).keySet().isEmpty()) {
            String messageId = this.stub.get(pluginId).get(queue).keySet().iterator().next();
            return CrawlerQueueMessage.newBuilder().setId(messageId).setJson(this.mapper.writeValueAsString((Object)this.stub.get(pluginId).get(queue).get(messageId))).build();
        }
        return null;
    }

    public void ackMessage(String pluginId, Queue queue, String messageId) {
        if (!(this.stub.containsKey(pluginId) && this.stub.get(pluginId).containsKey(queue) && this.stub.get(pluginId).get(queue).containsKey(messageId))) {
            throw new RuntimeException("message with messageId [" + messageId + "] is not known to the queue");
        }
        this.stub.get(pluginId).get(queue).remove(messageId);
    }

    public List<CrawlerMessage> getMessagesOnQueue(String pluginId, Queue queue) {
        return Optional.ofNullable(this.stub.get(pluginId)).flatMap(v -> Optional.ofNullable(v.get(queue)).map(e -> e.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList()))).orElse(new ArrayList());
    }

    public String prepareMessageId(String pluginId, Queue queue) {
        return String.valueOf(pluginId) + queue + this.messageIdCounter++;
    }
}

