/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.messages.BaseProbeMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerDataSourceDetails;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobMetadata;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.service.grpc.CrawlerApiServiceTestStub;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerCredentials;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerCredentialsPackage;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerEndpointServiceGrpc;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerProbeResult;
import com.xebialabs.agatha.shared.grpc.services.ingest.PollCrawlerUMMessageResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.ProbeResultMetadata;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMMessageRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMMessageResponse;
import com.xebialabs.agatha.shared.grpc.services.ingest.Queue;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BaseCrawlerUnitTests {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlerUnitTests.class);
    private static final String DATA_SOURCE_ID = "test";
    private static final String JOB_ERROR_MSG = "job failed";
    private static final String PROBE_ERROR_MSG = "Server could not reached!";
    private static final String API_USERNAME = "admin";
    private static final String API_PASSWORD = "admin";
    private InProcessServer<CrawlerEndpointServiceGrpc.CrawlerEndpointServiceImplBase> server;
    private CrawlerApiServiceTestStub crawlerService;
    private CrawlerCredentialsPackage crawlerCredentials;
    private String expectedFailedProbeResult;
    private ObjectMapper mapper;
    private ManagedChannel channel;
    private StreamObserver observer;
    public AbstractHttpCrawler crawler;
    @Parameterized.Parameter(value=0)
    public String pluginId;
    @Parameterized.Parameter(value=1)
    public Supplier<CrawlerMessage> messageSupplier;
    @Parameterized.Parameter(value=2)
    public Supplier<BaseProbeMessage> probeSupplier;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"plugin-1", () -> BaseCrawlerUnitTests.decorateMessage(new CrawlerMessage(), "plugin-1"), () -> BaseCrawlerUnitTests.decorateProbe(new BaseProbeMessage(), "plugin-1")}, {"plugin-2", () -> BaseCrawlerUnitTests.decorateMessage(new CrawlerMessage(), "plugin-2"), () -> BaseCrawlerUnitTests.decorateProbe(new BaseProbeMessage(), "plugin-2")}, {"plugin-3", () -> BaseCrawlerUnitTests.decorateMessage(new CrawlerMessage(), "plugin-3"), () -> BaseCrawlerUnitTests.decorateProbe(new BaseProbeMessage(), "plugin-3")});
    }

    private static <T extends CrawlerMessage<T>> T decorateMessage(T msg, String pluginId) {
        msg.setTenantId("testTenant").setPluginId(pluginId).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(DATA_SOURCE_ID)).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(new Date().getTime()).setFailures(AgathaConfiguration.getCrawlerMaxRetry()).setDelayUntil(Long.valueOf(new Date().getTime())));
        return msg;
    }

    private static <T extends BaseProbeMessage<T>> T decorateProbe(T probe, String pluginId) {
        probe.setTenantId("testTenant").setPluginId(pluginId).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(DATA_SOURCE_ID)).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(new Date().getTime()));
        return probe;
    }

    @Before
    public void init() throws Exception {
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new ProtobufModule());
        if (this.observer == null) {
            this.observer = (StreamObserver)Mockito.mock(StreamObserver.class);
        }
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.pluginId).directExecutor()).usePlaintext(true).build();
        this.channel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, () -> logger.info("gRPC channel closed!"));
        this.crawler = (AbstractHttpCrawler)Mockito.spy((Object)new AbstractHttpCrawler(this.pluginId, AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD){

            protected void setupGrpcChannel() {
                this.ingestionEndpoint = CrawlerEndpointServiceGrpc.newBlockingStub((Channel)BaseCrawlerUnitTests.this.channel);
            }

            public void initOrUpdateClient() {
            }

            protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
                return CrawlerJobResult.success();
            }

            protected ProbeResultMetadata.Builder probe(CrawlerJobWrapper crawlerJob) {
                String endpointStr = "";
                if (this.endpoint != null) {
                    endpointStr = this.endpoint.toString();
                }
                return ProbeResultMetadata.newBuilder().setIsSuccess(false).setReason(BaseCrawlerUnitTests.PROBE_ERROR_MSG).setEndpoint(endpointStr).setUsername(this.username);
            }
        });
        this.crawler.retryDelayMin = 0;
        this.crawler.sleepMs = 10;
        this.crawlerCredentials = CrawlerCredentialsPackage.newBuilder().setEndpoint("http://localhost").setBaseUiUrl("http://my-host").addCredentials(CrawlerCredentials.newBuilder().setUsername("admin").setPassword("admin")).build();
        this.expectedFailedProbeResult = this.crawler.mapper.writeValueAsString((Object)CrawlerProbeResult.newBuilder().addResults(ProbeResultMetadata.newBuilder().setIsSuccess(false).setReason(PROBE_ERROR_MSG).setEndpoint("http://localhost").setUsername("admin")).build());
        this.crawlerService = new CrawlerApiServiceTestStub(this.crawler.mapper);
        this.crawlerService.credentials = this.mapper.writeValueAsString((Object)this.crawlerCredentials);
        this.server = new InProcessServer((BindableService)this.crawlerService, this.pluginId);
        this.server.start();
        logger.info("Started mock crawler endpoint service [{}]", (Object)this.pluginId);
    }

    @After
    public void tearDown() throws InterruptedException {
        this.channel.shutdownNow();
        this.server.stop();
        this.server.blockUntilShutdown();
    }

    @Test
    public void scrapingTests() throws Exception {
        Assert.assertTrue((boolean)this.crawler.isRunning.get());
        Mockito.when((Object)this.crawler.crawlItem((CrawlerJobWrapper)ArgumentMatchers.any())).thenReturn((Object)CrawlerJobResult.fail((String)JOB_ERROR_MSG));
        this.sendTestMessageToQueue(this.pluginId, Queue.NORMAL, false);
        this.applyCrawlerLogic(true, true);
        Assert.assertEquals((Object)Queue.NORMAL, (Object)this.crawler.activeQueue);
        this.applyCrawlerLogic(true, true);
        Assert.assertEquals((Object)Queue.RETRIES, (Object)this.crawler.activeQueue);
        Mockito.when((Object)this.crawler.crawlItem((CrawlerJobWrapper)ArgumentMatchers.any())).thenReturn((Object)CrawlerJobResult.success());
        this.sendTestMessageToQueue(this.pluginId, Queue.PRIORITY, false);
        this.applyCrawlerLogic(true, true);
        Assert.assertEquals((Object)Queue.PRIORITY, (Object)this.crawler.activeQueue);
        this.crawler.activeQueue = Queue.RETRIES;
        Mockito.when((Object)this.crawler.crawlItem((CrawlerJobWrapper)ArgumentMatchers.any())).thenReturn((Object)CrawlerJobResult.fail((String)JOB_ERROR_MSG));
        this.sendTestMessageToQueue(this.pluginId, Queue.PRIORITY, true);
        this.applyCrawlerLogic(true, true);
        Assert.assertEquals((Object)Queue.PRIORITY, (Object)this.crawler.activeQueue);
    }

    protected void applyCrawlerLogic(boolean msgExists, boolean jobExists) throws Exception {
        Optional pollResponse = this.crawler.pollWorkQueue();
        Assert.assertTrue((boolean)pollResponse.isPresent());
        Assert.assertEquals((Object)msgExists, (Object)((PollCrawlerUMMessageResponse)pollResponse.get()).hasMessage());
        if (((PollCrawlerUMMessageResponse)pollResponse.get()).hasMessage()) {
            Assert.assertEquals((Object)"testTenant", (Object)((PollCrawlerUMMessageResponse)pollResponse.get()).getTenantId());
            Optional crawlerJob = this.crawler.handlePollResponse((PollCrawlerUMMessageResponse)pollResponse.get());
            Assert.assertEquals((Object)jobExists, (Object)crawlerJob.isPresent());
            if (crawlerJob.isPresent()) {
                Assert.assertEquals((Object)"testTenant", (Object)((CrawlerJobWrapper)crawlerJob.get()).getTenantId());
                this.crawler.setCredentials("admin", "admin");
                this.crawler.execute((CrawlerJobWrapper)crawlerJob.get());
                return;
            }
        }
        this.crawler.sleep();
    }

    private void sendTestMessageToQueue(String pluginId, Queue queue, boolean isProbe) throws JsonProcessingException {
        PushCrawlerUMMessageRequest.Builder request = PushCrawlerUMMessageRequest.newBuilder().setTenantId("testTenant").setPluginId(pluginId).setDataSourceId(DATA_SOURCE_ID).setQueue(queue);
        if (isProbe) {
            request.setMessage(this.crawler.mapper.writeValueAsString((Object)this.probeSupplier.get()));
        } else {
            request.setMessage(this.crawler.mapper.writeValueAsString((Object)this.messageSupplier.get()));
        }
        this.crawlerService.pushUMMessage(request.build(), (StreamObserver<PushCrawlerUMMessageResponse>)this.observer);
        ((StreamObserver)Mockito.verify((Object)this.observer)).onCompleted();
        Mockito.reset((Object[])new StreamObserver[]{this.observer});
    }

    static {
        System.setProperty("test-mode", "true");
    }
}

