/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Map;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public class IgnoringFieldsComparator
extends FieldByFieldComparator {
    private String[] fields;

    public IgnoringFieldsComparator(Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        super(comparatorByPropertyOrField, comparatorByType);
        this.fields = fields;
    }

    public IgnoringFieldsComparator(String ... fields) {
        this.fields = fields;
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToIgnoringGivenFields(actualElement, otherElement, this.comparatorByPropertyOrField, this.comparatorByType, this.fields);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return "field/property by field/property comparator on all fields/properties except " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(this.fields);
    }
}

