/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.api;

import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.HttpEntity;
import akka.http.javadsl.model.HttpRequest;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.CrawlerInputStream;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.agatha.crawlers.api.IngestionHttpClient;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.CrawlerResourcesMetrics;
import com.xebialabs.impact.api.PluginRuntimeConfig;
import com.xebialabs.impact.api.PullMessagesWithStreamingRequestVM;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import com.xebialabs.impact.api.SetContextKeyRequest;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestionApiRestImpl
implements IngestionApiAsync {
    private static final Logger logger = LoggerFactory.getLogger(IngestionApiRestImpl.class);
    private final ObjectMapper mapper;
    private final IngestionHttpClient httpClient;

    public IngestionApiRestImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.httpClient = new IngestionHttpClient();
    }

    @Override
    public CompletionStage<PullMessagesWithStreamingResponseVM> pullUMMessage(String pluginId, String networkId) {
        PullMessagesWithStreamingRequestVM vm = new PullMessagesWithStreamingRequestVM().setN(1).setPluginId(pluginId).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(networkId);
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/pull-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(vm))).thenApply(this.reader(PullMessagesWithStreamingResponseVM.class));
    }

    private <T> T readValue(String content, Class<T> valueType) {
        try {
            return this.mapper.readValue(content, valueType);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T> Function<ByteString, T> reader(Class<T> valueType) {
        return content -> this.readValue(content.utf8String(), valueType);
    }

    private byte[] writeValueAsBytes(Object vm) {
        try {
            return this.mapper.writeValueAsBytes(vm);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String writeValueAsString(Map<String, Object> payload) {
        try {
            return this.mapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public CompletionStage<PluginRuntimeConfig> pushCrawlerResourcesMetrics(CrawlerResourcesMetrics metrics) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/resources/metrics")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(metrics))).thenApply(this.reader(PluginRuntimeConfig.class));
    }

    @Override
    public CompletionStage<Void> pushUMMessage(PushCrawlerUMMessagesRequestVM messages) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(messages))).thenApply(a -> null);
    }

    @Override
    public CompletionStage<Void> ackUmMessages(AckUmMessagesVM acks) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/ack-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(acks))).thenApply(a -> {
            for (String messageId : acks.getMessageIds()) {
                logger.info("Acked: [{}]", (Object)messageId);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<PushCrawlerUMDataResponseVM> pushUMData(Map<String, Object> payload) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-data-with-streaming")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(payload))).thenApply(this.reader(PushCrawlerUMDataResponseVM.class));
    }

    @Override
    public CompletionStage<PushCrawlerUMDataResponseVM> pushUMDataAsSource(Map<String, Object> payload, Reader reader) {
        String json = this.writeValueAsString(payload);
        HttpEntity.Chunked chunked = HttpEntities.create((ContentType)ContentTypes.APPLICATION_JSON, StreamConverters.fromInputStream(() -> new CrawlerInputStream(json, reader)));
        return this.httpClient.request(HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-data-with-streaming")).withEntity(chunked)).thenApply(this.reader(PushCrawlerUMDataResponseVM.class));
    }

    @Override
    public CompletionStage<Void> pushProbeUmStatus(PushProbeUMStatusRequestVM pushProbeUMStatusRequestVM) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-probe-um-status")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(pushProbeUMStatusRequestVM))).thenApply(a -> null);
    }

    @Override
    public CompletionStage<CheckWhichUMArtefactsAreKnownResponseVM> checkWhichUMArtefactsAreKnown(CheckWhichUMArtefactsAreKnownRequestVM request) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/check-which-um-artefacts-are-known")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(request))).thenApply(this.reader(CheckWhichUMArtefactsAreKnownResponseVM.class));
    }

    @Override
    public CompletionStage<Void> reportCrawlerLog(ReportCrawlerLogMessageRequestVM request) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/report-crawler-log")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(request))).thenApply(a -> null);
    }

    @Override
    public CompletionStage<Void> sendContextKeyValues(SetContextKeyRequest request) {
        return this.httpClient.request((HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/set-context-key")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.writeValueAsBytes(request))).thenApply(a -> null);
    }

    @Override
    public void shutdown() {
        IngestionApiRestImpl ingestionApiRestImpl = this;
        ingestionApiRestImpl.httpClient.shutdown();
    }
}

