/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.bytebuddy.TypeCache;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.mock.SerializableMode;

class TypeCachingBytecodeGenerator
extends ReferenceQueue<ClassLoader>
implements BytecodeGenerator {
    private final Object BOOTSTRAP_LOCK = new Object();
    private final BytecodeGenerator bytecodeGenerator;
    private final TypeCache<SerializationFeatureKey> typeCache;

    public TypeCachingBytecodeGenerator(BytecodeGenerator bytecodeGenerator, boolean weak) {
        this.bytecodeGenerator = bytecodeGenerator;
        this.typeCache = new TypeCache.WithInlineExpunction<SerializationFeatureKey>(weak ? TypeCache.Sort.WEAK : TypeCache.Sort.SOFT);
    }

    public <T> Class<T> mockClass(final MockFeatures<T> params) {
        try {
            ClassLoader classLoader = params.mockedType.getClassLoader();
            return this.typeCache.findOrInsert(classLoader, new SerializationFeatureKey(params.mockedType, params.interfaces, params.serializableMode), new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return TypeCachingBytecodeGenerator.this.bytecodeGenerator.mockClass(params);
                }
            }, classLoader == null ? this.BOOTSTRAP_LOCK : classLoader);
        }
        catch (IllegalArgumentException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw exception;
        }
    }

    private static class SerializationFeatureKey
    extends TypeCache.SimpleKey {
        private final SerializableMode serializableMode;

        private SerializationFeatureKey(Class<?> type2, Set<Class<?>> additionalType, SerializableMode serializableMode) {
            super(type2, additionalType);
            this.serializableMode = serializableMode;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SerializationFeatureKey that = (SerializationFeatureKey)object;
            return this.serializableMode.equals((Object)that.serializableMode);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.serializableMode.hashCode();
            return result;
        }
    }
}

