/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public class OnFieldsComparator
extends FieldByFieldComparator {
    private String[] fields;

    public OnFieldsComparator(Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        super(comparatorByPropertyOrField, comparatorByType);
        Preconditions.checkArgument(!Arrays.isNullOrEmpty(fields), "No fields/properties specified", new Object[0]);
        for (String field2 : fields) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(field2) && !Strings.isNullOrEmpty(field2.trim()), "Null/blank fields/properties are invalid, fields/properties were %s", StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(fields));
        }
        this.fields = fields;
    }

    public OnFieldsComparator(String ... fields) {
        this(new HashMap(), new TypeComparators(), fields);
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToComparingOnlyGivenFields(actualElement, otherElement, this.comparatorByPropertyOrField, this.comparatorByType, this.fields);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    @Override
    public String toString() {
        if (this.fields.length == 1) {
            return "single field/property comparator on field/property " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf((Object)this.fields[0]);
        }
        return "field/property by field/property comparator on fields/properties " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(this.fields);
    }
}

