/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import org.powermock.core.MockInvocation;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockGateway {
    public static final Object PROCEED = new Object();
    public static final Object SUPPRESS = new Object();
    public static final String DONT_MOCK_NEXT_CALL = "DontMockNextCall";
    public static boolean MOCK_STANDARD_METHODS = true;
    public static boolean MOCK_GET_CLASS_METHOD = false;
    public static boolean MOCK_ANNOTATION_METHODS = false;

    public static Object newInstanceCall(Class<?> type2, Object[] args, Class<?>[] sig) throws Throwable {
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(type2);
        if (newInvocationControl != null) {
            if (type2.isMemberClass() && Modifier.isStatic(type2.getModifiers())) {
                if (args.length > 0 && (args[0] == null && sig[0].getCanonicalName() == null || args[args.length - 1] == null && sig[args.length - 1].getCanonicalName() == null) && sig.length > 0) {
                    args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, sig[0], false);
                }
            } else if ((type2.isLocalClass() || type2.isAnonymousClass() || type2.isMemberClass()) && args.length > 0 && sig.length > 0 && sig[0].equals(type2.getEnclosingClass())) {
                args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, sig[0], true);
            }
            return newInvocationControl.invoke(type2, args, sig);
        }
        if (MockRepository.shouldSuppressConstructor(WhiteboxImpl.getConstructor(type2, sig))) {
            return WhiteboxImpl.getFirstParentConstructor(type2);
        }
        return PROCEED;
    }

    public static Object fieldCall(Object instanceOrClassContainingTheField, Class<?> classDefiningField, String fieldName, Class<?> fieldType) {
        if (MockRepository.shouldSuppressField(WhiteboxImpl.getField(classDefiningField, fieldName))) {
            return TypeUtils.getDefaultValue(fieldType);
        }
        return PROCEED;
    }

    public static Object staticConstructorCall(String className) {
        if (MockRepository.shouldSuppressStaticInitializerFor(className)) {
            return "suppress";
        }
        return PROCEED;
    }

    public static Object constructorCall(Class<?> type2, Object[] args, Class<?>[] sig) throws Throwable {
        Constructor<?> constructor = WhiteboxImpl.getConstructor(type2, sig);
        if (MockRepository.shouldSuppressConstructor(constructor)) {
            return null;
        }
        return PROCEED;
    }

    public static Object methodCall(Object instance, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(instance, methodName, args, sig, returnTypeAsString);
    }

    public static Object methodCall(Class<?> type2, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(type2, methodName, args, sig, returnTypeAsString);
    }

    private static Object doMethodCall(Object object, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        if (!MockGateway.shouldMockMethod(methodName, sig)) {
            return PROCEED;
        }
        MockInvocation mockInvocation = new MockInvocation(object, methodName, sig);
        MethodInvocationControl methodInvocationControl = mockInvocation.getMethodInvocationControl();
        Object returnValue = null;
        if (MockGateway.isEqualsMethod(mockInvocation) && !MockGateway.isStaticMethod(mockInvocation)) {
            returnValue = MockGateway.tryHandleEqualsMethod(mockInvocation);
        }
        if (returnValue != null) {
            return returnValue;
        }
        return MockGateway.doMethodCall(object, args, returnTypeAsString, mockInvocation, methodInvocationControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doMethodCall(Object object, Object[] args, String returnTypeAsString, MockInvocation mockInvocation, MethodInvocationControl methodInvocationControl) throws Throwable {
        Object returnValue;
        if (MockRepository.shouldSuppressMethod(mockInvocation.getMethod(), mockInvocation.getObjectType())) {
            returnValue = TypeUtils.getDefaultValue(returnTypeAsString);
        } else if (MockRepository.shouldStubMethod(mockInvocation.getMethod())) {
            returnValue = MockRepository.getMethodToStub(mockInvocation.getMethod());
        } else if (methodInvocationControl != null && methodInvocationControl.isMocked(mockInvocation.getMethod()) && MockGateway.shouldMockThisCall()) {
            returnValue = methodInvocationControl.invoke(object, mockInvocation.getMethod(), args);
            if (returnValue == SUPPRESS) {
                returnValue = TypeUtils.getDefaultValue(returnTypeAsString);
            }
        } else if (MockRepository.hasMethodProxy(mockInvocation.getMethod())) {
            InvocationHandler invocationHandler = MockRepository.removeMethodProxy(mockInvocation.getMethod());
            try {
                returnValue = invocationHandler.invoke(object, mockInvocation.getMethod(), args);
            }
            finally {
                MockRepository.putMethodProxy(mockInvocation.getMethod(), invocationHandler);
            }
        } else {
            returnValue = PROCEED;
        }
        return returnValue;
    }

    private static Object tryHandleEqualsMethod(MockInvocation mockInvocation) {
        if (mockInvocation.getMethod().getParameterTypes().length == 1 && mockInvocation.getMethod().getParameterTypes()[0] == Object.class && Modifier.isFinal(mockInvocation.getMethod().getModifiers())) {
            return PROCEED;
        }
        if (MockGateway.calledFromMockito()) {
            return PROCEED;
        }
        return null;
    }

    private static boolean isEqualsMethod(MockInvocation mockInvocation) {
        return "equals".equals(mockInvocation.getMethod().getName());
    }

    private static boolean isStaticMethod(MockInvocation mockInvocation) {
        return Modifier.isStatic(mockInvocation.getMethod().getModifiers());
    }

    private static boolean calledFromMockito() {
        StackTraceElement[] stackTrace;
        if (NoMockito.noMockito) {
            return false;
        }
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("org.mockito.")) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldMockMethod(String methodName, Class<?>[] sig) {
        if (MockGateway.isJavaStandardMethod(methodName, sig) && !MOCK_STANDARD_METHODS) {
            return false;
        }
        if (MockGateway.isGetClassMethod(methodName, sig) && !MOCK_GET_CLASS_METHOD) {
            return false;
        }
        return !MockGateway.isAnnotationMethod(methodName, sig) || MOCK_ANNOTATION_METHODS;
    }

    private static boolean isJavaStandardMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("equals") && sig.length == 1 || methodName.equals("hashCode") && sig.length == 0 || methodName.equals("toString") && sig.length == 0;
    }

    private static boolean isGetClassMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("getClass") && sig.length == 0;
    }

    private static boolean isAnnotationMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("isAnnotationPresent") && sig.length == 1 || methodName.equals("getAnnotation") && sig.length == 1;
    }

    private static boolean shouldMockThisCall() {
        Object shouldSkipMockingOfNextCall = MockRepository.getAdditionalState(DONT_MOCK_NEXT_CALL);
        boolean shouldMockThisCall = shouldSkipMockingOfNextCall == null;
        MockRepository.removeAdditionalState(DONT_MOCK_NEXT_CALL);
        return shouldMockThisCall;
    }

    private static Object[] copyArgumentsForInnerOrLocalOrAnonymousClass(Object[] args, Class<?> sig, boolean excludeEnclosingInstance) {
        int end;
        int start;
        Object[] newArgs = new Object[args.length - 1];
        int j = 0;
        if (args[0] == null && sig == null || excludeEnclosingInstance) {
            start = 1;
            end = args.length;
        } else {
            start = 0;
            end = args.length - 1;
        }
        for (int i = start; i < end; ++i) {
            newArgs[j++] = args[i];
        }
        args = newArgs;
        return args;
    }

    private static final class NoMockito {
        static final boolean noMockito = Package.getPackage("org.mockito") == null;

        private NoMockito() {
        }
    }
}

