/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.LocalDate;
import java.util.Arrays;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeToday;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractLocalDateAssert<SELF extends AbstractLocalDateAssert<SELF>>
extends AbstractTemporalAssert<SELF, LocalDate> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDate to compare actual with should not be null";

    protected AbstractLocalDateAssert(LocalDate actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isBefore(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return this.isBefore(this.parse(localDateAsString));
    }

    public SELF isBeforeOrEqualTo(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return this.isBeforeOrEqualTo(this.parse(localDateAsString));
    }

    public SELF isAfterOrEqualTo(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (((LocalDate)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return this.isAfterOrEqualTo(this.parse(localDateAsString));
    }

    public SELF isAfter(LocalDate other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateAssert.assertLocalDateParameterIsNotNull(other);
        if (!((LocalDate)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isAfter(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return this.isAfter(this.parse(localDateAsString));
    }

    public SELF isEqualTo(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return (SELF)((AbstractLocalDateAssert)this.isEqualTo(this.parse(localDateAsString)));
    }

    public SELF isNotEqualTo(String localDateAsString) {
        AbstractLocalDateAssert.assertLocalDateAsStringParameterIsNotNull(localDateAsString);
        return (SELF)((AbstractLocalDateAssert)this.isNotEqualTo(this.parse(localDateAsString)));
    }

    public SELF isIn(String ... localDatesAsString) {
        this.checkIsNotNullAndNotEmpty(localDatesAsString);
        return (SELF)((AbstractLocalDateAssert)this.isIn(AbstractLocalDateAssert.convertToLocalDateArray(localDatesAsString)));
    }

    public SELF isNotIn(String ... localDatesAsString) {
        this.checkIsNotNullAndNotEmpty(localDatesAsString);
        return (SELF)((AbstractLocalDateAssert)this.isNotIn(AbstractLocalDateAssert.convertToLocalDateArray(localDatesAsString)));
    }

    public SELF isToday() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((LocalDate)this.actual).isEqual(LocalDate.now())) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeToday.shouldBeToday((LocalDate)this.actual));
        }
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isBetween(LocalDate startInclusive, LocalDate endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(LocalDate startInclusive, LocalDate endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, false, false);
        return (SELF)((AbstractLocalDateAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startInclusive, String endInclusive) {
        return this.isStrictlyBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    @Override
    protected LocalDate parse(String localDateAsString) {
        return LocalDate.parse(localDateAsString);
    }

    private static Object[] convertToLocalDateArray(String ... localDatesAsString) {
        return Arrays.stream(localDatesAsString).map(LocalDate::parse).toArray();
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given LocalDate array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given LocalDate array should not be empty", new Object[0]);
    }

    private static void assertLocalDateAsStringParameterIsNotNull(String localDateAsString) {
        Preconditions.checkArgument(localDateAsString != null, "The String representing the LocalDate to compare actual with should not be null", new Object[0]);
    }

    private static void assertLocalDateParameterIsNotNull(LocalDate other) {
        Preconditions.checkArgument(other != null, NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }
}

