/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.visitor;

import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class ExceptionTableSensitiveMethodVisitor
extends MethodVisitor {
    private boolean trigger = true;

    protected ExceptionTableSensitiveMethodVisitor(int api, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
    }

    private void considerEndOfExceptionTable() {
        if (this.trigger) {
            this.trigger = false;
            this.onAfterExceptionTable();
        }
    }

    protected abstract void onAfterExceptionTable();

    @Override
    public final void visitLabel(Label label) {
        this.considerEndOfExceptionTable();
        this.onVisitLabel(label);
    }

    protected void onVisitLabel(Label label) {
        super.visitLabel(label);
    }

    @Override
    public final void visitIntInsn(int opcode, int operand) {
        this.considerEndOfExceptionTable();
        this.onVisitIntInsn(opcode, operand);
    }

    protected void onVisitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public final void visitVarInsn(int opcode, int var) {
        this.considerEndOfExceptionTable();
        this.onVisitVarInsn(opcode, var);
    }

    protected void onVisitVarInsn(int opcode, int offset) {
        super.visitVarInsn(opcode, offset);
    }

    @Override
    public final void visitTypeInsn(int opcode, String type2) {
        this.considerEndOfExceptionTable();
        this.onVisitTypeInsn(opcode, type2);
    }

    protected void onVisitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, type2);
    }

    @Override
    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.considerEndOfExceptionTable();
        this.onVisitFieldInsn(opcode, owner, name, desc);
    }

    protected void onVisitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Override
    public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, desc);
    }

    @Deprecated
    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.considerEndOfExceptionTable();
        super.visitMethodInsn(opcode, owner, name, descriptor);
    }

    @Override
    public final void visitMethodInsn(int opcode, String owner, String name, String desc, boolean iFace) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, desc, iFace);
    }

    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor, boolean iFace) {
        super.visitMethodInsn(opcode, owner, name, descriptor, iFace);
    }

    @Override
    public final void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.considerEndOfExceptionTable();
        this.onVisitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    protected void onVisitInvokeDynamicInsn(String name, String descriptor, Handle handle2, Object ... argument) {
        super.visitInvokeDynamicInsn(name, descriptor, handle2, argument);
    }

    @Override
    public final void visitJumpInsn(int opcode, Label label) {
        this.considerEndOfExceptionTable();
        this.onVisitJumpInsn(opcode, label);
    }

    protected void onVisitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public final void visitLdcInsn(Object cst) {
        this.considerEndOfExceptionTable();
        this.onVisitLdcInsn(cst);
    }

    protected void onVisitLdcInsn(Object constant) {
        super.visitLdcInsn(constant);
    }

    @Override
    public final void visitIincInsn(int var, int increment) {
        this.considerEndOfExceptionTable();
        this.onVisitIincInsn(var, increment);
    }

    protected void onVisitIincInsn(int offset, int increment) {
        super.visitIincInsn(offset, increment);
    }

    @Override
    public final void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        this.considerEndOfExceptionTable();
        this.onVisitTableSwitchInsn(min2, max2, dflt, labels);
    }

    protected void onVisitTableSwitchInsn(int min2, int max2, Label defaultTarget, Label ... label) {
        super.visitTableSwitchInsn(min2, max2, defaultTarget, label);
    }

    @Override
    public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.considerEndOfExceptionTable();
        this.onVisitLookupSwitchInsn(dflt, keys, labels);
    }

    protected void onVisitLookupSwitchInsn(Label defaultTarget, int[] keys, Label[] key) {
        super.visitLookupSwitchInsn(defaultTarget, keys, key);
    }

    @Override
    public final void visitMultiANewArrayInsn(String desc, int dims) {
        this.considerEndOfExceptionTable();
        this.onVisitMultiANewArrayInsn(desc, dims);
    }

    protected void onVisitMultiANewArrayInsn(String descriptor, int dimensions) {
        super.visitMultiANewArrayInsn(descriptor, dimensions);
    }

    @Override
    public final void visitInsn(int opcode) {
        this.considerEndOfExceptionTable();
        this.onVisitInsn(opcode);
    }

    protected void onVisitInsn(int opcode) {
        super.visitInsn(opcode);
    }
}

