/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.com.xebialabs.agatha.crawlers.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.service.keyvaluestorage.KeyValueStorageMock;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.CrawlerResourcesMetrics;
import com.xebialabs.impact.api.PluginRuntimeConfig;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.junit.Assert;

public class IngestionApiMock
implements IngestionApi {
    private KeyValueStorageMock keyValueStorage;
    private List<CrawlerMessageWithCredentials> messageList = new ArrayList<CrawlerMessageWithCredentials>();
    private ObjectMapper objectMapper = new ObjectMapper();
    private CrawlerCredentialsDTO credentials;
    public static String TENANT_ID = "testTenant";

    public IngestionApiMock() {
        this.keyValueStorage = new KeyValueStorageMock(new ObjectMapper());
    }

    public KeyValueStorageMock getKeyValueStorage() {
        return this.keyValueStorage;
    }

    @Override
    public PullMessagesWithStreamingResponseVM pullUMMessage(String pluginId, String networkId) {
        List<CrawlerMessageWithCredentials> collect = this.messageList.stream().filter(m -> m.getMessage().getDelayedUntil() <= System.currentTimeMillis()).limit(1L).map(this::cloneObject).collect(Collectors.toList());
        return new PullMessagesWithStreamingResponseVM().setMessages(collect);
    }

    @Override
    public PluginRuntimeConfig pushCrawlerResourcesMetrics(CrawlerResourcesMetrics metrics) {
        return null;
    }

    private CrawlerMessageWithCredentials cloneObject(CrawlerMessageWithCredentials m) {
        try {
            return (CrawlerMessageWithCredentials)this.objectMapper.readValue(this.objectMapper.writeValueAsString(m), m.getClass());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void pushUMMessage(PushCrawlerUMMessagesRequestVM messages) {
        messages.getMessages().stream().map(m -> {
            m.setDelayedUntil(m.getDelayedUntil() == 0L ? m.getMetadata().getDelayUntil() : m.getDelayedUntil());
            return new CrawlerMessageWithCredentials().setDataSourceId(m.getDataSourceDetails().getDataSourceId()).setTenantId(m.getTenantId()).setMessage((BaseCrawlerMessage)m).setMessageId(UUID.randomUUID().toString()).setCredentials(this.credentials);
        }).forEach(this.messageList::add);
    }

    @Override
    public void ackUmMessages(AckUmMessagesVM acks) {
        for (String id : acks.getMessageIds()) {
            this.messageList = this.messageList.stream().filter(m -> !m.getMessageId().equals(id)).collect(Collectors.toList());
        }
    }

    private String getPineTreeMapKey(Map<String, Object> map, int level) {
        if (level == 0) {
            return map.keySet().iterator().next();
        }
        return this.getPineTreeMapKey((Map)map.values().iterator().next(), level - 1);
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMData(Map<String, Object> payload) {
        Map pineTreeMapValue = (Map)this.getPineTreeMapValue(payload, 4);
        if (pineTreeMapValue.containsKey("data")) {
            String json;
            try {
                json = this.objectMapper.writeValueAsString(pineTreeMapValue.get("data"));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
            this.pushStringToData(payload, json);
        }
        return new PushCrawlerUMDataResponseVM().setKnown(false);
    }

    private void pushStringToData(Map<String, Object> payload, String json) {
        this.keyValueStorage.putJson(String.format("%s/data/%s/%s/%s/%s", this.getPineTreeMapKey(payload, 0), this.getPineTreeMapKey(payload, 1), this.getPineTreeMapKey(payload, 2), this.getPineTreeMapKey(payload, 3), this.getPineTreeMapKey(payload, 4)), json);
    }

    private Object getPineTreeMapValue(Map<String, Object> payload, int i) {
        if (i == 0) {
            return payload.values().iterator().next();
        }
        return this.getPineTreeMapValue((Map)payload.values().iterator().next(), i - 1);
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMDataAsSource(Map<String, Object> payload, Reader initialReader) {
        try {
            int numCharsRead;
            char[] arr = new char[8192];
            StringBuilder builder = new StringBuilder();
            while ((numCharsRead = initialReader.read(arr, 0, arr.length)) != -1) {
                builder.append(arr, 0, numCharsRead);
            }
            initialReader.close();
            String json = JSONObject.quote(builder.toString());
            this.pushStringToData(payload, this.objectMapper.writeValueAsString(this.getPineTreeMapValue(payload, 5)).replace("@~DATA_STREAM~@", json.substring(1, json.length() - 1)));
            return new PushCrawlerUMDataResponseVM().setKnown(false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void pushProbeUmStatus(PushProbeUMStatusRequestVM pushProbeUMStatusRequestVM) {
        try {
            this.keyValueStorage.putJson(String.format("%s/dataSourceProbeResult/%s/%s", pushProbeUMStatusRequestVM.getTenantId(), pushProbeUMStatusRequestVM.getPluginId(), pushProbeUMStatusRequestVM.getDataSourceId()) + "/" + 123, this.objectMapper.writeValueAsString(pushProbeUMStatusRequestVM.getProbeStatus()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public CheckWhichUMArtefactsAreKnownResponseVM checkWhichUMArtefactsAreKnown(CheckWhichUMArtefactsAreKnownRequestVM request) {
        return null;
    }

    public void assertNumberOfDelayedMessagesInQueue(int num) {
        Assert.assertEquals(num, this.messageList.stream().filter(m -> m.getMessage().getDelayedUntil() > 0L).count());
    }

    public IngestionApiMock setCredentials(CrawlerCredentialsDTO credentials) {
        this.credentials = credentials;
        return this;
    }

    public void assertNumberOfMessagesIncludingDelayed(int i) {
        Assert.assertEquals(i, this.messageList.size());
    }

    @Override
    public void reportCrawlerLog(ReportCrawlerLogMessageRequestVM reportCrawlerLogMessageRequestVM) {
    }

    @Override
    public void shutdown() {
    }
}

