/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.auxiliary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodAccessorFactory;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodCallProxy
implements AuxiliaryType {
    private static final String FIELD_NAME_PREFIX = "argument";
    private final Implementation.SpecialMethodInvocation specialMethodInvocation;
    private final boolean serializableProxy;
    private final Assigner assigner;

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy) {
        this(specialMethodInvocation, serializableProxy, Assigner.DEFAULT);
    }

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy, Assigner assigner) {
        this.specialMethodInvocation = specialMethodInvocation;
        this.serializableProxy = serializableProxy;
        this.assigner = assigner;
    }

    private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
        LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>();
        int currentIndex = 0;
        if (!methodDescription.isStatic()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), methodDescription.getDeclaringType().asErasure());
        }
        for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), parameterDescription.getType().asErasure());
        }
        return typeDescriptions;
    }

    private static String fieldName(int index) {
        return String.format("%s%d", FIELD_NAME_PREFIX, index);
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, MethodAccessorFactory methodAccessorFactory) {
        Type[] typeArray;
        MethodDescription.InDefinedShape accessorMethod = methodAccessorFactory.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.DEFAULT);
        LinkedHashMap<String, TypeDescription> parameterFields = MethodCallProxy.extractFields(accessorMethod);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition receiverTypeDefinition = new ByteBuddy(classFileVersion).with(PrecomputedMethodGraph.INSTANCE).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER).implement(new Type[]{Runnable.class, Callable.class}).intercept(new MethodCall(accessorMethod, this.assigner));
        if (this.serializableProxy) {
            Class[] classArray = new Class[1];
            typeArray = classArray;
            classArray[0] = Serializable.class;
        } else {
            typeArray = new Class[]{};
        }
        DynamicType.Builder<Object> builder = receiverTypeDefinition.implement(typeArray).defineConstructor(new ModifierContributor.ForMethod[0]).withParameters(parameterFields.values()).intercept(ConstructorCall.INSTANCE);
        for (Map.Entry<String, TypeDescription> field2 : parameterFields.entrySet()) {
            builder = builder.defineField(field2.getKey(), (TypeDefinition)field2.getValue(), Visibility.PRIVATE);
        }
        return builder.make();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCallProxy)) {
            return false;
        }
        MethodCallProxy other = (MethodCallProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Implementation.SpecialMethodInvocation this$specialMethodInvocation = this.specialMethodInvocation;
        Implementation.SpecialMethodInvocation other$specialMethodInvocation = other.specialMethodInvocation;
        if (this$specialMethodInvocation == null ? other$specialMethodInvocation != null : !this$specialMethodInvocation.equals(other$specialMethodInvocation)) {
            return false;
        }
        if (this.serializableProxy != other.serializableProxy) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        return !(this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodCallProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Implementation.SpecialMethodInvocation $specialMethodInvocation = this.specialMethodInvocation;
        result = result * 59 + ($specialMethodInvocation == null ? 43 : $specialMethodInvocation.hashCode());
        result = result * 59 + (this.serializableProxy ? 79 : 97);
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        return result;
    }

    public static class AssignableSignatureCall
    implements StackManipulation {
        private final Implementation.SpecialMethodInvocation specialMethodInvocation;
        private final boolean serializable;

        public AssignableSignatureCall(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializable) {
            this.specialMethodInvocation = specialMethodInvocation;
            this.serializable = serializable;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription auxiliaryType = implementationContext.register(new MethodCallProxy(this.specialMethodInvocation, this.serializable));
            return new StackManipulation.Compound(TypeCreation.of(auxiliaryType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(this.specialMethodInvocation.getMethodDescription()).prependThisReference(), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)auxiliaryType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignableSignatureCall)) {
                return false;
            }
            AssignableSignatureCall other = (AssignableSignatureCall)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Implementation.SpecialMethodInvocation this$specialMethodInvocation = this.specialMethodInvocation;
            Implementation.SpecialMethodInvocation other$specialMethodInvocation = other.specialMethodInvocation;
            if (this$specialMethodInvocation == null ? other$specialMethodInvocation != null : !this$specialMethodInvocation.equals(other$specialMethodInvocation)) {
                return false;
            }
            return this.serializable == other.serializable;
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssignableSignatureCall;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Implementation.SpecialMethodInvocation $specialMethodInvocation = this.specialMethodInvocation;
            result = result * 59 + ($specialMethodInvocation == null ? 43 : $specialMethodInvocation.hashCode());
            result = result * 59 + (this.serializable ? 79 : 97);
            return result;
        }
    }

    protected static class MethodCall
    implements Implementation {
        private final MethodDescription accessorMethod;
        private final Assigner assigner;

        protected MethodCall(MethodDescription accessorMethod, Assigner assigner) {
            this.accessorMethod = accessorMethod;
            this.assigner = assigner;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodCall)) {
                return false;
            }
            MethodCall other = (MethodCall)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MethodDescription this$accessorMethod = this.accessorMethod;
            MethodDescription other$accessorMethod = other.accessorMethod;
            if (this$accessorMethod == null ? other$accessorMethod != null : !this$accessorMethod.equals(other$accessorMethod)) {
                return false;
            }
            Assigner this$assigner = this.assigner;
            Assigner other$assigner = other.assigner;
            return !(this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodCall;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodDescription $accessorMethod = this.accessorMethod;
            result = result * 59 + ($accessorMethod == null ? 43 : $accessorMethod.hashCode());
            Assigner $assigner = this.assigner;
            result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
            return result;
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                ArrayList<StackManipulation.Compound> fieldLoadings = new ArrayList<StackManipulation.Compound>(fieldList.size());
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoadings.add(new StackManipulation.Compound(MethodVariableAccess.loadThis(), FieldAccess.forField(fieldDescription).read()));
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(new StackManipulation.Compound(fieldLoadings), MethodInvocation.invoke(MethodCall.this.accessorMethod), MethodCall.this.assigner.assign(MethodCall.this.accessorMethod.getReturnType(), instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
            }
        }
    }

    protected static enum ConstructorCall implements Implementation
    {
        INSTANCE;

        private final MethodDescription objectTypeDefaultConstructor = (MethodDescription)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        protected static class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index] = new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodVariableAccess.load((ParameterDescription)instrumentedMethod.getParameters().get(index)), FieldAccess.forField(fieldDescription).write());
                    ++index;
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Appender)) {
                    return false;
                }
                Appender other = (Appender)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Appender;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }
        }
    }

    protected static enum PrecomputedMethodGraph implements MethodGraph.Compiler
    {
        INSTANCE;

        private final MethodGraph.Linked methodGraph;

        @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"}, justification="Precomputed method graph is not intended for serialization")
        private PrecomputedMethodGraph() {
            LinkedHashMap<MethodDescription.SignatureToken, MethodGraph.Node> nodes = new LinkedHashMap<MethodDescription.SignatureToken, MethodGraph.Node>();
            MethodDescription.Latent callMethod = new MethodDescription.Latent(new TypeDescription.ForLoadedType(Callable.class), "call", 1025, Collections.emptyList(), TypeDescription.Generic.OBJECT, Collections.emptyList(), Collections.singletonList(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Exception.class)), Collections.emptyList(), AnnotationValue.UNDEFINED, TypeDescription.Generic.UNDEFINED);
            nodes.put(callMethod.asSignatureToken(), new MethodGraph.Node.Simple(callMethod));
            MethodDescription.Latent runMethod = new MethodDescription.Latent(new TypeDescription.ForLoadedType(Runnable.class), "run", 1025, Collections.emptyList(), TypeDescription.Generic.VOID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), AnnotationValue.UNDEFINED, TypeDescription.Generic.UNDEFINED);
            nodes.put(runMethod.asSignatureToken(), new MethodGraph.Node.Simple(runMethod));
            MethodGraph.Simple methodGraph = new MethodGraph.Simple(nodes);
            this.methodGraph = new MethodGraph.Linked.Delegation(methodGraph, methodGraph, Collections.<TypeDescription, MethodGraph>emptyMap());
        }

        @Override
        public MethodGraph.Linked compile(TypeDescription typeDescription) {
            return this.compile(typeDescription, typeDescription);
        }

        @Override
        public MethodGraph.Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
            return this.methodGraph;
        }
    }
}

