/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.instance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.creation.instance.InstantiationException;
import org.mockito.internal.creation.instance.Instantiator;
import org.mockito.internal.util.Primitives;
import org.mockito.internal.util.StringUtil;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class ConstructorInstantiator
implements Instantiator {
    private final boolean hasOuterClassInstance;
    private final Object[] constructorArgs;

    public ConstructorInstantiator(boolean hasOuterClassInstance, Object ... constructorArgs) {
        this.hasOuterClassInstance = hasOuterClassInstance;
        this.constructorArgs = constructorArgs;
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        return this.withParams(cls, this.constructorArgs);
    }

    private <T> T withParams(Class<T> cls, Object ... params) {
        LinkedList matchingConstructors = new LinkedList();
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                Class<?>[] types = constructor.getParameterTypes();
                if (!ConstructorInstantiator.paramsMatch(types, params)) continue;
                this.evaluateConstructor(matchingConstructors, constructor);
            }
            if (matchingConstructors.size() == 1) {
                return ConstructorInstantiator.invokeConstructor((Constructor)matchingConstructors.get(0), params);
            }
        }
        catch (Exception e) {
            throw this.paramsException(cls, e);
        }
        if (matchingConstructors.size() == 0) {
            throw this.noMatchingConstructor(cls);
        }
        throw this.multipleMatchingConstructors(cls, matchingConstructors);
    }

    private static <T> T invokeConstructor(Constructor<?> constructor, Object ... params) throws java.lang.InstantiationException, IllegalAccessException, InvocationTargetException {
        AccessibilityChanger accessibility = new AccessibilityChanger();
        accessibility.enableAccess(constructor);
        return (T)constructor.newInstance(params);
    }

    private InstantiationException paramsException(Class<?> cls, Exception e) {
        return new InstantiationException(StringUtil.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Please ensure the target class has " + this.constructorArgsString() + " and executes cleanly."), e);
    }

    private String constructorArgTypes() {
        int argPos = 0;
        if (this.hasOuterClassInstance) {
            ++argPos;
        }
        Object[] constructorArgTypes = new String[this.constructorArgs.length - argPos];
        for (int i = argPos; i < this.constructorArgs.length; ++i) {
            constructorArgTypes[i - argPos] = this.constructorArgs[i] == null ? null : this.constructorArgs[i].getClass().getName();
        }
        return Arrays.toString(constructorArgTypes);
    }

    private InstantiationException noMatchingConstructor(Class<?> cls) {
        String constructorString = this.constructorArgsString();
        String outerInstanceHint = "";
        if (this.hasOuterClassInstance) {
            outerInstanceHint = " and provided outer instance is correct";
        }
        return new InstantiationException(StringUtil.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Please ensure that the target class has " + constructorString + outerInstanceHint + "."), null);
    }

    private String constructorArgsString() {
        String constructorString = this.constructorArgs.length == 0 || this.hasOuterClassInstance && this.constructorArgs.length == 1 ? "a 0-arg constructor" : "a constructor that matches these argument types: " + this.constructorArgTypes();
        return constructorString;
    }

    private InstantiationException multipleMatchingConstructors(Class<?> cls, List<Constructor<?>> constructors) {
        return new InstantiationException(StringUtil.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Multiple constructors could be matched to arguments of types " + this.constructorArgTypes() + ":", StringUtil.join("", " - ", constructors), "If you believe that Mockito could do a better job deciding on which constructor to use, please let us know.", "Ticket 685 contains the discussion and a workaround for ambiguous constructors using inner class.", "See https://github.com/mockito/mockito/issues/685"), null);
    }

    private static boolean paramsMatch(Class<?>[] types, Object[] params) {
        if (params.length != types.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] == null ? types[i].isPrimitive() : !types[i].isPrimitive() && !types[i].isInstance(params[i]) || types[i].isPrimitive() && !types[i].equals(Primitives.primitiveTypeOf(params[i].getClass())))) continue;
            return false;
        }
        return true;
    }

    private void evaluateConstructor(List<Constructor<?>> matchingConstructors, Constructor<?> constructor) {
        boolean newHasBetterParam = false;
        boolean existingHasBetterParam = false;
        Class<?>[] paramTypes = constructor.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType.isPrimitive()) continue;
            for (Constructor<?> existingCtor : matchingConstructors) {
                Class<?> existingParamType = existingCtor.getParameterTypes()[i];
                if (paramType == existingParamType) continue;
                if (paramType.isAssignableFrom(existingParamType)) {
                    existingHasBetterParam = true;
                    continue;
                }
                newHasBetterParam = true;
            }
        }
        if (!existingHasBetterParam) {
            matchingConstructors.clear();
        }
        if (newHasBetterParam || !existingHasBetterParam) {
            matchingConstructors.add(constructor);
        }
    }
}

