/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.StringUtil;
import org.mockito.plugins.AnnotationEngine;

public class SpyAnnotationEngine
implements AnnotationEngine,
org.mockito.configuration.AnnotationEngine {
    @Override
    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        for (Field field2 : fields = context.getDeclaredFields()) {
            if (!field2.isAnnotationPresent(Spy.class) || field2.isAnnotationPresent(InjectMocks.class)) continue;
            SpyAnnotationEngine.assertNoIncompatibleAnnotations(Spy.class, field2, Mock.class, Captor.class);
            field2.setAccessible(true);
            try {
                Object instance = field2.get(testInstance);
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                if (instance != null) {
                    field2.set(testInstance, SpyAnnotationEngine.spyInstance(field2, instance));
                    continue;
                }
                field2.set(testInstance, SpyAnnotationEngine.spyNewInstance(testInstance, field2));
            }
            catch (Exception e) {
                throw new MockitoException("Unable to initialize @Spy annotated field '" + field2.getName() + "'.\n" + e.getMessage(), e);
            }
        }
    }

    private static Object spyInstance(Field field2, Object instance) {
        return Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field2.getName()));
    }

    private static Object spyNewInstance(Object testInstance, Field field2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        MockSettings settings = Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field2.getName());
        Class<?> type2 = field2.getType();
        if (type2.isInterface()) {
            return Mockito.mock(type2, settings.useConstructor(new Object[0]));
        }
        int modifiers = type2.getModifiers();
        if (SpyAnnotationEngine.typeIsPrivateAbstractInnerClass(type2, modifiers)) {
            throw new MockitoException(StringUtil.join("@Spy annotation can't initialize private abstract inner classes.", "  inner class: '" + type2.getSimpleName() + "'", "  outer class: '" + type2.getEnclosingClass().getSimpleName() + "'", "", "You should augment the visibility of this inner class"));
        }
        if (SpyAnnotationEngine.typeIsNonStaticInnerClass(type2, modifiers)) {
            Class<?> enclosing = type2.getEnclosingClass();
            if (!enclosing.isInstance(testInstance)) {
                throw new MockitoException(StringUtil.join("@Spy annotation can only initialize inner classes declared in the test.", "  inner class: '" + type2.getSimpleName() + "'", "  outer class: '" + enclosing.getSimpleName() + "'", ""));
            }
            return Mockito.mock(type2, settings.useConstructor(new Object[0]).outerInstance(testInstance));
        }
        Constructor<?> constructor = SpyAnnotationEngine.noArgConstructorOf(type2);
        if (Modifier.isPrivate(constructor.getModifiers())) {
            constructor.setAccessible(true);
            return Mockito.mock(type2, settings.spiedInstance(constructor.newInstance(new Object[0])));
        }
        return Mockito.mock(type2, settings.useConstructor(new Object[0]));
    }

    private static Constructor<?> noArgConstructorOf(Class<?> type2) {
        Constructor<?> constructor;
        try {
            constructor = type2.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MockitoException("Please ensure that the type '" + type2.getSimpleName() + "' has a no-arg constructor.");
        }
        return constructor;
    }

    private static boolean typeIsNonStaticInnerClass(Class<?> type2, int modifiers) {
        return !Modifier.isStatic(modifiers) && type2.getEnclosingClass() != null;
    }

    private static boolean typeIsPrivateAbstractInnerClass(Class<?> type2, int modifiers) {
        return Modifier.isPrivate(modifiers) && Modifier.isAbstract(modifiers) && type2.getEnclosingClass() != null;
    }

    private static void assertNoIncompatibleAnnotations(Class<? extends Annotation> annotation, Field field2, Class<? extends Annotation> ... undesiredAnnotations) {
        for (Class<? extends Annotation> u : undesiredAnnotations) {
            if (!field2.isAnnotationPresent(u)) continue;
            throw Reporter.unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

