/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.xebialabs.agatha.logging.LogbackTester;
import com.xebialabs.agatha.logging.StackdriverLogbackLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class StackdriverLogbackLayoutTest {
    private TestAppender testAppender;
    private Logger testLogger;

    @Before
    public void setupLogback() throws Exception {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        StackdriverLogbackLayout testedLayout = new StackdriverLogbackLayout();
        testedLayout.setPattern("%msg");
        testedLayout.setServiceName("myservice");
        testedLayout.setServiceVersion("1.0.0");
        this.testAppender = new TestAppender(context, testedLayout);
        this.testAppender.start();
        this.testLogger = context.getLogger(LogbackTester.class);
        this.testLogger.addAppender((Appender)this.testAppender);
        this.testLogger.setLevel(Level.DEBUG);
        this.testLogger.setAdditive(false);
    }

    @Test
    public void testMessageFormatFromILoggingEvent() throws Exception {
        Thread logTestThread = new Thread((Runnable)new LogbackTester(this.testLogger), "logTestThread");
        logTestThread.start();
        logTestThread.join();
        String[] logMessages = this.testAppender.getLogOutput().split("\n");
        System.out.println(this.testAppender.getLogOutput());
        this.assertLogMessage("Info message output doesn't match expected", this.loadLogMessage(0), logMessages[0]);
        this.assertLogMessage("Debug message output doesn't match expected", this.loadLogMessage(1), logMessages[1]);
        this.assertLogMessage("Error message output doesn't match expected", this.loadLogMessage(2), logMessages[2]);
    }

    private void assertLogMessage(String message, String expected, String actual) {
        this.assertPropContains(message, expected, actual, "message");
        this.assertProp(message, expected, actual, "thread");
        this.assertProp(message, expected, actual, "severity");
        this.assertProp(message, expected, actual, "sourceLocation.file");
        this.assertProp(message, expected, actual, "sourceLocation.line");
        this.assertProp(message, expected, actual, "sourceLocation.function");
        this.assertProp(message, expected, actual, "serviceContext.service");
        this.assertProp(message, expected, actual, "serviceContext.version");
    }

    private void assertProp(String message, String expected, String actual, String prop) {
        Assert.assertEquals((String)message, (Object)JsonPath.read((String)expected, (String)prop, (Filter[])new Filter[0]), (Object)((String)JsonPath.read((String)actual, (String)prop, (Filter[])new Filter[0])));
    }

    private void assertPropContains(String message, String expected, String actual, String prop) {
        Assert.assertTrue((String)message, (boolean)((String)JsonPath.read((String)actual, (String)prop, (Filter[])new Filter[0])).contains((CharSequence)JsonPath.read((String)expected, (String)prop, (Filter[])new Filter[0])));
    }

    private String loadLogMessage(int index) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("logback-logmessage-" + index + ".json");){
            String string = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    static class TestAppender
    extends OutputStreamAppender<ILoggingEvent> {
        TestAppender(LoggerContext context, StackdriverLogbackLayout testedLayout) {
            this.setOutputStream(new ByteArrayOutputStream());
            this.setImmediateFlush(true);
            this.setContext((Context)context);
            testedLayout.setContext((Context)context);
            testedLayout.start();
            LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
            encoder.setLayout((Layout)testedLayout);
            encoder.setContext((Context)context);
            encoder.start();
            this.setEncoder((Encoder)encoder);
        }

        public String getLogOutput() throws UnsupportedEncodingException {
            ByteArrayOutputStream stream = (ByteArrayOutputStream)this.getOutputStream();
            return stream.toString("UTF-8");
        }
    }
}

