/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.junit.Test;
import org.junit.experimental.theories.Theory;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;
import org.powermock.modules.junit4.common.internal.PowerMockJUnitRunnerDelegate;
import org.powermock.modules.junit4.common.internal.impl.JUnitVersion;
import org.powermock.modules.junit4.internal.impl.PowerMockRunNotifier;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.exceptions.ConstructorNotFoundException;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;

public class DelegatingPowerMockRunner
extends Runner
implements PowerMockJUnitRunnerDelegate,
Filterable {
    private final String testClassName;
    private final Runner delegate;
    private final ClassLoader testClassLoader;
    private final Method[] testMethods;
    private final PowerMockTestNotifier powerMockTestNotifier;

    public DelegatingPowerMockRunner(Class<?> klass) throws Throwable {
        this(klass, null);
    }

    public DelegatingPowerMockRunner(Class<?> klass, String[] methodsToRun) throws Throwable {
        this(klass, methodsToRun, null);
    }

    public DelegatingPowerMockRunner(Class<?> klass, String[] methodsToRun, PowerMockTestListener[] listeners) throws Exception {
        this.testClassName = klass.getName();
        this.delegate = DelegatingPowerMockRunner.createDelegate(klass);
        this.testClassLoader = klass.getClassLoader();
        this.testMethods = DelegatingPowerMockRunner.determineTestMethods(klass, methodsToRun);
        this.powerMockTestNotifier = new PowerMockTestNotifierImpl(listeners == null ? new PowerMockTestListener[]{} : listeners);
    }

    private static Method[] determineTestMethods(Class<?> testClass, String[] testMethodNames) {
        ArrayList<Method> testMethods = new ArrayList<Method>();
        for (Method m : testClass.getMethods()) {
            if (!m.isAnnotationPresent(Test.class) && !m.isAnnotationPresent(Theory.class)) continue;
            testMethods.add(m);
        }
        if (testMethods.isEmpty()) {
            for (String testMethodName : testMethodNames) {
                try {
                    testMethods.add(testClass.getMethod(testMethodName, new Class[0]));
                }
                catch (NoSuchMethodException ignore) {
                    System.err.println(ignore.getMessage());
                }
            }
        }
        return testMethods.toArray(new Method[testMethods.size()]);
    }

    private static Runner createDelegate(final Class<?> testClass) throws Exception {
        return DelegatingPowerMockRunner.withContextClassLoader(testClass.getClassLoader(), new Callable<Runner>(){

            @Override
            public Runner call() throws Exception {
                try {
                    return Whitebox.invokeConstructor(testClass.isAnnotationPresent(PowerMockRunnerDelegate.class) ? testClass.getAnnotation(PowerMockRunnerDelegate.class).value() : PowerMockRunnerDelegate.DefaultJUnitRunner.class, new Class[]{Class.class}, new Object[]{testClass});
                }
                catch (ConstructorNotFoundException rootProblem) {
                    if (testClass.isAnnotationPresent(PowerMockRunnerDelegate.class) && JUnitVersion.isGreaterThanOrEqualTo("4.5")) {
                        try {
                            return Whitebox.invokeConstructor(testClass.getAnnotation(PowerMockRunnerDelegate.class).value(), PowerMockRunnerDelegate.SinceJUnit_4_5.runnerAlternativeConstructorParams(), new Object[]{testClass, PowerMockRunnerDelegate.SinceJUnit_4_5.newRunnerBuilder()});
                        }
                        catch (ConstructorNotFoundException constructorNotFoundException) {
                            // empty catch block
                        }
                    }
                    throw rootProblem;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withContextClassLoader(ClassLoader loader, Callable<T> callable) throws Exception {
        ClassLoader originalClassLoaderBackup = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoaderBackup);
        }
    }

    @Override
    public void run(final RunNotifier notifier) {
        try {
            DelegatingPowerMockRunner.withContextClassLoader(this.testClassLoader, new Callable<Void>(){

                @Override
                public Void call() {
                    PowerMockRunNotifier powerNotifier = new PowerMockRunNotifier(notifier, DelegatingPowerMockRunner.this.powerMockTestNotifier, DelegatingPowerMockRunner.this.testMethods);
                    try {
                        GlobalNotificationBuildSupport.prepareTestSuite(DelegatingPowerMockRunner.this.testClassName, powerNotifier);
                        DelegatingPowerMockRunner.this.delegate.run(powerNotifier);
                    }
                    finally {
                        GlobalNotificationBuildSupport.closePendingTestSuites(powerNotifier);
                    }
                    return null;
                }
            });
        }
        catch (Exception cannotHappen) {
            throw new Error(cannotHappen);
        }
    }

    @Override
    public Description getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public int getTestCount() {
        return this.delegate.testCount();
    }

    @Override
    public Class<?> getTestClass() {
        return this.getDescription().getTestClass();
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.delegate instanceof Filterable) {
            ((Filterable)((Object)this.delegate)).filter(filter);
        }
    }
}

