/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
implements Map<K, V> {
    private List<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>();

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> i = this.entries.iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            if (entry.getKey() != key) continue;
            i.remove();
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public V get(Object key) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getKey() != key) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getKey() != key) continue;
            return entry.setValue(value);
        }
        SimpleEntry<K, V> entry = new SimpleEntry<K, V>(key, value);
        this.entries.add(entry);
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getValue() != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> identityHashSet = new HashSet<K>();
        for (Map.Entry<K, V> entry : this.entries) {
            identityHashSet.add(entry.getKey());
        }
        return identityHashSet;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        Set<Map.Entry<K, V>> entrySet = t.entrySet();
        for (Map.Entry<K, V> entry : entrySet) {
            this.entries.add(entry);
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<V> values() {
        HashSet<V> hashSet = new HashSet<V>();
        for (Map.Entry<K, V> entry : this.entries) {
            hashSet.add(entry.getValue());
        }
        return hashSet;
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

