/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration;

import org.powermock.configuration.Configuration;
import org.powermock.configuration.ConfigurationFactory;
import org.powermock.configuration.MockitoConfiguration;
import org.powermock.configuration.PowerMockConfiguration;
import org.powermock.configuration.support.ConfigurationFactoryImpl;

public final class GlobalConfiguration {
    private static ConfigurationFactory configurationFactory = new ConfigurationFactoryImpl();
    private static final ThreadLocal<MockitoConfiguration> MOCKITO_CONFIGURATION = new ThreadLocal();
    private static final ThreadLocal<PowerMockConfiguration> POWER_MOCK_CONFIGURATION = new ThreadLocal();

    public static MockitoConfiguration mockitoConfiguration() {
        return new GlobalConfiguration().getMockitoConfiguration();
    }

    public static PowerMockConfiguration powerMockConfiguration() {
        return new GlobalConfiguration().getPowerMockConfiguration();
    }

    public static void clear() {
        configurationFactory = new ConfigurationFactoryImpl();
        MOCKITO_CONFIGURATION.remove();
        POWER_MOCK_CONFIGURATION.remove();
    }

    public static void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        GlobalConfiguration.configurationFactory = configurationFactory;
    }

    private GlobalConfiguration() {
        if (MOCKITO_CONFIGURATION.get() == null) {
            MOCKITO_CONFIGURATION.set(this.createConfig(MockitoConfiguration.class));
        }
        if (POWER_MOCK_CONFIGURATION.get() == null) {
            POWER_MOCK_CONFIGURATION.set(this.createConfig(PowerMockConfiguration.class));
        }
    }

    private PowerMockConfiguration getPowerMockConfiguration() {
        return POWER_MOCK_CONFIGURATION.get();
    }

    private MockitoConfiguration getMockitoConfiguration() {
        return MOCKITO_CONFIGURATION.get();
    }

    private <T extends Configuration<T>> T createConfig(Class<T> configurationClass) {
        return configurationFactory.create(configurationClass);
    }
}

