/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.integration;

import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.com.xebialabs.agatha.crawlers.api.IngestionApiMock;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.CrawlerDataSourceDetails;
import com.xebialabs.impact.api.CrawlerJobMetadata;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.stream.StreamSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCrawlerTest<C extends AbstractCrawler> {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlerTest.class);
    public static final String API_PASSWORD_FAIL = "fail!";
    private DataSourceTypeEnum dataSourceType;
    protected MockWebServer mockWebServer;
    protected PushCrawlerUMMessagesRequestVM probeRequest;
    protected PushCrawlerUMMessagesRequestVM crawlRequest;
    protected C crawler;
    private IngestionApiMock ingestionApiMock = new IngestionApiMock();
    protected static final double THROTTLE_FACTOR = 4.0;
    protected CrawlerCredentialsDTO singleCredentials;
    protected CrawlerCredentialsDTO multipleCredentials;
    protected CrawlerCredentialsDTO wrongCredentials;
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    public BaseCrawlerTest(DataSourceTypeEnum dataSourceType) {
        this.dataSourceType = dataSourceType;
        this.configureEnv();
    }

    protected C crawler() {
        return this.crawler;
    }

    protected PushCrawlerUMMessagesRequestVM probeRequestMessage(String pluginId, String dataSourceId, String tenantId) {
        return new PushCrawlerUMMessagesRequestVM().setPluginId(pluginId).setDataSourceId(dataSourceId).setTenantId(tenantId).setMessages(Collections.singletonList(this.probeMessage(new BaseCrawlerMessage().setProbeId(123L), pluginId, dataSourceId)));
    }

    protected PushCrawlerUMMessagesRequestVM crawlRequestMessage(String pluginId, String dataSourceId, String tenantId) {
        return new PushCrawlerUMMessagesRequestVM().setPluginId(pluginId).setDataSourceId(dataSourceId).setTenantId(tenantId).setMessages(Collections.singletonList(this.crawlMessageJson(pluginId, dataSourceId).setLaunch(true)));
    }

    protected BaseCrawlerMessage crawlMessageJson(String pluginId, String dataSourceId) {
        return ((BaseCrawlerMessage)((BaseCrawlerMessage)((BaseCrawlerMessage)new BaseCrawlerMessage().setTenantId(AgathaConfiguration.getTenantId())).setPluginId(pluginId)).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(dataSourceId).setNetworkId(AgathaConfiguration.getNetworkId()))).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(System.currentTimeMillis()));
    }

    protected String getApiEndpoint(String protocol) {
        try {
            return new URL(protocol + "://" + this.mockWebServer.getHostName() + ":" + this.mockWebServer.getPort() + "/").toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Before
    public void setUp() throws IOException, IllegalAccessException, InstantiationException {
        this.singleCredentials = this.singleCredentials();
        this.multipleCredentials = this.multipleCredentials();
        this.wrongCredentials = this.wrongCredentials();
        logger.info("Started mock crawler endpoint service [{}]", (Object)this.dataSourceType.name());
    }

    private void configureEnv() {
        this.environmentVariables.set("XLINSIGHT_TENANT_ID", IngestionApiMock.TENANT_ID);
        this.environmentVariables.set("XLINSIGHT_API_PASSWORD", "admin");
        this.environmentVariables.set("XLINSIGHT_CRAWL_YEARS_BACK", "2");
        this.environmentVariables.set("XLINSIGHT_CRAWLER_RETRY_DELAY_MIN", "0");
        Assert.assertEquals(IngestionApiMock.TENANT_ID, System.getenv("XLINSIGHT_TENANT_ID"));
        Assert.assertEquals("2", System.getenv("XLINSIGHT_CRAWL_YEARS_BACK"));
        Assert.assertEquals("0", System.getenv("XLINSIGHT_CRAWLER_RETRY_DELAY_MIN"));
        Assert.assertEquals("admin", System.getenv("XLINSIGHT_API_PASSWORD"));
    }

    protected abstract CrawlerCredentialsDTO wrongCredentials();

    protected abstract CrawlerCredentialsDTO multipleCredentials();

    protected abstract CrawlerCredentialsDTO singleCredentials();

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.ingestionApiMock.getKeyValueStorage().getValues().clear();
    }

    protected <T extends BaseCrawlerMessage> T probeMessage(T probe, String pluginId, String dataSourceId) {
        ((BaseCrawlerMessage)((BaseCrawlerMessage)((BaseCrawlerMessage)probe.setTenantId(IngestionApiMock.TENANT_ID)).setPluginId(pluginId)).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(dataSourceId))).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(new Date().getTime()));
        return probe;
    }

    protected long calculateKVStorageSize() {
        return StreamSupport.stream(this.ingestionApiMock.getKeyValueStorage().list("/").spliterator(), false).count();
    }

    protected URL createSafeUrl(String s2) {
        try {
            return new URL(s2);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        System.setProperty("test-mode", "true");
    }
}

