/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.enumeration;

import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;

public interface EnumerationDescription
extends NamedElement {
    public String getValue();

    public TypeDescription getEnumerationType();

    public <T extends Enum<T>> T load(Class<T> var1);

    public static class Latent
    extends AbstractBase {
        private final TypeDescription enumerationType;
        private final String value;

        public Latent(TypeDescription enumerationType, String value) {
            this.enumerationType = enumerationType;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public TypeDescription getEnumerationType() {
            return this.enumerationType;
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type2) {
            if (!this.enumerationType.represents(type2)) {
                throw new IllegalArgumentException(type2 + " does not represent " + this.enumerationType);
            }
            return Enum.valueOf(type2, this.value);
        }
    }

    public static class ForLoadedEnumeration
    extends AbstractBase {
        private final Enum<?> value;

        public ForLoadedEnumeration(Enum<?> value) {
            this.value = value;
        }

        public static List<EnumerationDescription> asList(Enum<?>[] enumerations) {
            ArrayList<EnumerationDescription> result = new ArrayList<EnumerationDescription>(enumerations.length);
            for (Enum<?> enumeration : enumerations) {
                result.add(new ForLoadedEnumeration(enumeration));
            }
            return result;
        }

        @Override
        public String getValue() {
            return this.value.name();
        }

        @Override
        public TypeDescription getEnumerationType() {
            return new TypeDescription.ForLoadedType(this.value.getDeclaringClass());
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type2) {
            return (T)(this.value.getDeclaringClass() == type2 ? this.value : Enum.valueOf(type2, this.value.name()));
        }
    }

    public static abstract class AbstractBase
    implements EnumerationDescription {
        @Override
        public String getActualName() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof EnumerationDescription && ((EnumerationDescription)other).getEnumerationType().equals(this.getEnumerationType()) && ((EnumerationDescription)other).getValue().equals(this.getValue());
        }

        public int hashCode() {
            return this.getValue().hashCode() + 31 * this.getEnumerationType().hashCode();
        }

        public String toString() {
            return this.getValue();
        }
    }
}

