/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

public class ClassLoaderUtil {
    public static <T> Class<T> loadClass(Class<T> type2, ClassLoader classloader) {
        return ClassLoaderUtil.loadClass(type2.getName(), classloader);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassLoaderUtil.loadClass(className, ClassLoaderUtil.class.getClassLoader());
    }

    public static <T> boolean hasClass(Class<T> type2, ClassLoader classloader) {
        try {
            ClassLoaderUtil.loadClass(type2.getName(), classloader);
            return true;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                return false;
            }
            throw e;
        }
    }

    public static <T> Class<T> loadClass(String className, ClassLoader classloader) {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        if (classloader == null) {
            throw new IllegalArgumentException("classloader cannot be null");
        }
        try {
            return Class.forName(className, false, classloader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

