/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;

public class FieldTypeMatcherStrategy
extends FieldMatcherStrategy {
    final Class<?> expectedFieldType;

    public FieldTypeMatcherStrategy(Class<?> fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("field type cannot be null.");
        }
        this.expectedFieldType = fieldType;
    }

    @Override
    public boolean matches(Field field2) {
        return this.expectedFieldType.equals(field2.getType());
    }

    @Override
    public void notFound(Class<?> type2, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field of type \"%s\" could be found in the class hierarchy of %s.", isInstanceField ? "instance" : "static", this.expectedFieldType.getName(), type2.getName()));
    }

    public String toString() {
        return "type " + this.expectedFieldType.getName();
    }
}

